/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import build.Core;
import inifiles.IniFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import win7pecore.Win7PE;

public class Update {
    Win7PE winpe;
    File patch;
    String version;

    public Update(Win7PE thePE) {
        this.winpe = thePE;
        this.patch = new File(Core.sys.appDir, "update.ini");
        this.version = Core.version;
    }

    public boolean action() {
        if (this.patch.exists()) {
            IniFile ini = new IniFile(this.patch);
            if (this.version.equals("2015.06.12")) {
                int delCount = Integer.parseInt(ini.keyRead("Deletes", "Count", "0"));
                for (int i = 1; i <= delCount; ++i) {
                    String key = "Delete" + String.valueOf(i);
                    String name = ini.keyRead("Deletes", key, "");
                    if ("".equals(name)) continue;
                    File cand = new File(this.winpe.coreFolder, name);
                    cand.delete();
                }
                String driver = ini.keyRead("CustomDrivers", "CheckActivate", "True");
                try {
                    ini.closeFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(Win7PE.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
                if ("True".equalsIgnoreCase(driver)) {
                    boolean doActivate = this.checkActivateDriver(this.winpe.winPeLibrary.getDriversFolder());
                    this.winpe.projectSettings.write("CustomDrivers", this.boolString(doActivate));
                }
                this.winpe.projectSettings.write("DriverPacks", "False");
            } else if (this.version.equals("???")) {
                // empty if block
            }
            File tmp = new File(this.patch.getParentFile(), this.patch.getName() + "." + this.version);
            this.patch.renameTo(tmp);
            return true;
        }
        return false;
    }

    private String boolString(boolean value) {
        String val = String.valueOf(value);
        return val.substring(0, 1).toUpperCase() + val.substring(1);
    }

    private boolean checkActivateDriver(File folder) {
        String[] extensions = new String[]{"install"};
        Collection<File> theFiles = FileUtils.listFiles(folder, extensions, true);
        return !theFiles.isEmpty();
    }
}

