/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import build.Core;
import downloads.common;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.RegHeader;
import relink.MSlink;
import utils.ExtractSevenZip;
import utils.Settings;
import utils.files;
import win7pecore.WinPeLibrary;

public class Shortcuts {
    Settings settings = null;
    boolean desktopShortcut = false;
    boolean startmenuShortcut = false;
    String linkName = "";
    String pluginName = "";
    String pluginID = "";
    String linkExe = "";
    File peExe = null;
    File linkFile = null;
    File pluginFolder = null;
    File targetDirFile = null;
    File cdDirFile = null;
    File pluginSubDir = null;
    File programsSubDir = null;
    File localTargetFolder = null;
    File peTargetDir = null;
    String pluginType = "";
    String category = "";
    String desktopFolder = "";
    String startmenuFolder = "";
    boolean runFromRAM;
    char driveLetter = (char)88;
    WinPeLibrary peLib = null;
    String shortcutCommand = null;

    public Shortcuts(File settingsFile) {
        this.settings = new Settings(settingsFile, "Settings for Win7PE component");
        this.pluginType = this.settings.read("!Type");
        this.pluginName = this.settings.read("!Name");
        this.pluginID = this.settings.read("ID");
        this.category = this.settings.read("!Category");
        this.runFromRAM = this.settings.read("RunFromRAM", "True").equalsIgnoreCase("True");
        this.targetDirFile = Core.sys.build.folderPeWIM;
        this.cdDirFile = Core.sys.build.folderBase;
        File localPluginDir = common.getFolderPlugins();
        this.pluginSubDir = new File(new File(localPluginDir.getName(), this.category), this.pluginName);
        this.programsSubDir = new File("Program Files", this.pluginName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDescription(File candidateExe) {
        File exePath = candidateExe.getParentFile();
        File muiPath = new File(exePath, Core.sys.source.defaultLanguage);
        File candidate = new File(muiPath, candidateExe.getName() + ".mui");
        String result = null;
        if (candidate.exists()) {
            FileInputStream fis = null;
            try {
                int start;
                String search = "FileDescription";
                byte[] bSrch = new byte["FileDescription".length() * 2];
                int p = 0;
                for (start = 0; start < "FileDescription".length(); ++start) {
                    bSrch[p++] = (byte)"FileDescription".charAt(start);
                    bSrch[p++] = 0;
                }
                int len = bSrch.length;
                fis = new FileInputStream(candidate);
                byte[] buffer = new byte[(int)candidate.length()];
                fis.read(buffer);
                fis.close();
                int pointer = 0;
                for (start = 0; start < buffer.length - len; ++start) {
                    boolean found = true;
                    for (p = 0; p < len; ++p) {
                        if (buffer[start + p] == bSrch[p]) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    pointer = start + p + 4;
                    break;
                }
                if (pointer != 0) {
                    len = 0;
                    while (buffer[pointer + len] != 0 | buffer[pointer + len + 1] != 0) {
                        len += 2;
                    }
                    byte[] val = new byte[len];
                    System.arraycopy(buffer, pointer, val, 0, len);
                    result = new String(val, "UTF-16LE");
                    if (result.contains(" DLL")) {
                        result = result.replace(" DLL", "");
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return result;
    }

    public void getInfo() {
        this.desktopShortcut = this.settings.read("DesktopShortcut", "False)").equalsIgnoreCase("True");
        this.startmenuShortcut = this.settings.read("StartMenuShortcut", "False)").equalsIgnoreCase("True");
        if (this.desktopShortcut | this.startmenuShortcut) {
            File theDrive;
            File ramDepending;
            if (this.runFromRAM) {
                ramDepending = this.targetDirFile;
                theDrive = new File("X:");
                this.driveLetter = (char)88;
            } else {
                ramDepending = this.cdDirFile;
                theDrive = new File(Core.sys.settings.read("CD-Drive", "Y:"));
                this.driveLetter = (char)89;
            }
            String targetDir = this.settings.read("TargetFolder", "");
            if (targetDir.equals("$Default")) {
                targetDir = this.pluginSubDir.getPath();
            } else if (targetDir.equals("$Programs\\$Default")) {
                targetDir = this.programsSubDir.getPath();
            } else if (targetDir.equals("$WinSys")) {
                File winDir = new File("Windows");
                winDir = new File(winDir, "System32");
                targetDir = winDir.getPath();
            } else if (targetDir.startsWith("$Programs")) {
                File programsDir = this.programsSubDir.getParentFile();
                int p = targetDir.lastIndexOf("\\");
                programsDir = new File(programsDir, targetDir.substring(p + 1));
                targetDir = programsDir.getPath();
            }
            this.peTargetDir = new File(theDrive, targetDir);
            this.localTargetFolder = new File(ramDepending, targetDir);
            this.linkName = this.settings.read("ShortcutFileName", "$Default");
            if ("$Default".equals(this.linkName)) {
                this.linkName = this.pluginName + ".lnk";
            }
            this.linkExe = this.settings.read("ShortcutTarget");
            if (this.linkExe.equalsIgnoreCase("$Default")) {
                this.linkExe = this.pluginName + ".exe";
            }
            this.peExe = new File(this.peTargetDir, this.linkExe);
        }
    }

    public void setPeLib(WinPeLibrary lib) {
        this.peLib = lib;
    }

    private void singleAssoc(RegHeader header, String single, String command) {
        String description;
        String reference;
        if (!single.equals("")) {
            reference = this.pluginName + "." + single.toUpperCase();
            description = reference + " File";
            String path = "Classes\\." + single.toUpperCase();
            header.createValue(path, "", 1, reference);
        } else {
            reference = this.pluginName;
            description = reference + " Application";
        }
        String newKey = "Classes\\" + reference;
        header.createValue(newKey, "", 1, description);
        String iconKey = newKey + "\\DefaultIcon";
        header.createValue(iconKey, "", 1, this.peExe.getAbsolutePath() + ",0");
        newKey = newKey + "\\shell\\open\\command";
        header.createValue(newKey, "", 1, this.shortcutCommand);
    }

    private String createShortcutCommand() {
        String command = this.settings.read("AssociationCommand", "");
        if (command.equals("")) {
            command = "\"$Exe\" \"%1\"";
        } else if (command.equalsIgnoreCase("$Default")) {
            command = "\"$Exe\" \"%1\"";
        } else {
            return null;
        }
        this.shortcutCommand = command.replace("$Exe", this.peExe.getAbsolutePath());
        return command;
    }

    public void createAssocs(RegHeader header) {
        String command = this.createShortcutCommand();
        if (command == null) {
            return;
        }
        String arg = this.settings.read("Associations");
        if (arg == null) {
            return;
        }
        String[] list = arg.split(",");
        this.singleAssoc(header, "", command);
        for (int i = 0; i < list.length; ++i) {
            this.singleAssoc(header, list[i], command);
        }
    }

    public void doOpenWith(RegHeader header) {
        String open = this.settings.read("OpenWith", "False");
        if (open.equalsIgnoreCase("True")) {
            this.createShortcutCommand();
            String theOpen = "Open with " + this.pluginName;
            String newKey = "Classes\\*\\shell\\" + theOpen;
            header.createValue(newKey, "", 1, theOpen);
            newKey = newKey + "\\command";
            header.createValue(newKey, "", 1, this.shortcutCommand);
        }
    }

    public void createShortcuts() {
        this.linkFile = this.linkName.endsWith(".zip") ? (!this.pluginID.equals("") ? new File(this.pluginFolder, this.linkName) : this.peLib.copyResourceToTempFile(this.pluginName + "/" + this.pluginName + ".zip")) : this.generateShortcut();
        if (this.linkFile != null) {
            if (this.desktopShortcut) {
                this.desktopFolder = this.settings.read("DesktopFolder");
                if (this.desktopFolder.equalsIgnoreCase("$Default")) {
                    this.desktopFolder = this.category;
                }
                this.copyShortcut("Desktop", this.linkFile, this.desktopFolder, this.driveLetter);
            }
            if (this.startmenuShortcut) {
                this.startmenuFolder = this.settings.read("StartMenuFolder");
                if (this.startmenuFolder.equalsIgnoreCase("$Default")) {
                    this.startmenuFolder = this.category;
                }
                this.copyShortcut("StartMenu", this.linkFile, this.startmenuFolder, this.driveLetter);
            }
        }
    }

    public File getPeExe() {
        return this.peExe;
    }

    public String getLinkExe() {
        return this.linkExe;
    }

    public File getLocalTargetFolder() {
        return this.localTargetFolder;
    }

    public String getPluginExeName() {
        return this.peExe.getName();
    }

    String getOptionString(String key) {
        String entry = "";
        if (this.settings.hasKey(key).booleanValue()) {
            entry = this.settings.read(key);
        }
        if (entry.equals("-")) {
            entry = "";
        }
        return entry;
    }

    int getOptionInt(String option) {
        String entry;
        int result = -1;
        if (this.settings.hasKey(option).booleanValue() && !"".equals(entry = this.settings.read(option))) {
            result = Integer.parseInt(entry);
        }
        return result;
    }

    File generateShortcut() {
        String openmodus;
        String workdir;
        String icon;
        String arguments;
        String comment;
        MSlink newLink = new MSlink();
        String target = this.peExe.getPath().replace(System.getProperty("file.separator"), "\\");
        newLink.setTarget(target, false);
        Settings pluginSettings = (Settings)Core.temp.get("pluginSettings");
        String theCaption = pluginSettings.getProperties().getProperty("ShortcutCaption", "");
        if (theCaption.equalsIgnoreCase("Description")) {
            String nativeName;
            String mainName = this.getOptionString("MainName");
            if (mainName.equals("")) {
                nativeName = Shortcuts.getDescription(new File(this.localTargetFolder, this.linkExe));
                if (nativeName != null) {
                    this.linkName = nativeName.concat(".lnk");
                }
            } else if (mainName.startsWith("@")) {
                nativeName = Shortcuts.getDescription(new File(this.localTargetFolder, mainName.substring(1)));
                if (nativeName != null) {
                    this.linkName = nativeName.concat(".lnk");
                }
            } else {
                this.linkName = mainName.concat(".lnk");
            }
        }
        if (!(comment = this.getOptionString("ShortcutComment")).equals("")) {
            newLink.setComment(comment);
        }
        if (!(arguments = this.getOptionString("ShortcutArguments")).equals("")) {
            newLink.setArguments(arguments);
        }
        if (!(icon = this.getOptionString("ShortcutIconFile")).equals("")) {
            newLink.setIcon(icon);
        }
        if (!(workdir = this.getOptionString("ShortcutWorkDir")).equals("")) {
            newLink.setWorkingDir(workdir);
        }
        int modus = (openmodus = this.getOptionString("OpenModus")).equals("SW_SHOWMAXIMIZED") ? 3 : (openmodus.equals("SW_SHOWMINNOACTIVE") ? 7 : 1);
        newLink.setShowWindowMode(modus);
        int iconIndex = this.getOptionInt("ShortcutIconIndex");
        if (iconIndex != -1) {
            newLink.setIconIndex(iconIndex);
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        this.linkFile = new File(tempDir, this.linkName);
        newLink.save(this.linkFile);
        return this.linkFile;
    }

    void copyShortcut(String type, File shPath, String subDir, char cdDriveLetter) {
        File target = null;
        File winDirFolder = new File(this.targetDirFile, "Windows");
        File winSysFolder = new File(winDirFolder, "System32");
        File profile = new File(winSysFolder, "config");
        profile = new File(profile, "systemprofile");
        File roaming = new File(profile, "AppData");
        roaming = new File(roaming, "Roaming");
        roaming = new File(roaming, "Microsoft");
        roaming = new File(roaming, "Windows");
        if (type.equalsIgnoreCase("Desktop")) {
            target = new File(profile, "DeskTop");
        } else if (type.equalsIgnoreCase("StartMenu")) {
            File menu = new File(roaming, "Start Menu");
            target = new File(menu, "Programs");
        } else if (type.equalsIgnoreCase("SendTo")) {
            target = new File(roaming, "SendTo");
        }
        if (target != null) {
            if (!subDir.equals("$Default")) {
                target = new File(target, subDir);
            }
            files.mkdirs(target);
            String name = shPath.getName();
            File trg = new File(target, name);
            String ext = files.getExtension(shPath);
            if (ext.equalsIgnoreCase("zip")) {
                try {
                    WinPeLibrary lib = new WinPeLibrary(null);
                    lib.zipExtractAll(shPath, target);
                }
                catch (ExtractSevenZip.ExtractionException ex) {
                    Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                try {
                    files.copyFile(shPath, trg);
                    Shortcuts.changeDriveLetter(trg, cdDriveLetter);
                }
                catch (IOException ex) {
                    Logger.getLogger(Shortcuts.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static boolean changeDriveLetter(File trg, char newLetter) throws IOException {
        boolean res = false;
        if (trg.exists()) {
            long length = trg.length();
            byte[] bytes = new byte[(int)length];
            FileInputStream is2 = null;
            try {
                is2 = new FileInputStream(trg);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (is2 != null) {
                ((InputStream)is2).read(bytes);
                ((InputStream)is2).close();
            }
            int i = 1;
            while ((long)i < length) {
                char tst;
                if (bytes[i - 1] == 58 && bytes[i] == 92 && ((tst = (char)bytes[i - 2]) == 'y' || tst == 'Y' || tst == 'x' || tst == 'X')) {
                    bytes[i - 2] = (byte)newLetter;
                    FileOutputStream os = new FileOutputStream(trg);
                    ((OutputStream)os).write(bytes);
                    res = true;
                    break;
                }
                ++i;
            }
        }
        return res;
    }
}

