/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import bsh2java.log;
import build.Core;
import downloads.common;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import reg.RegHeader;
import utils.ExtractSevenZip;
import utils.Settings;
import utils.currentOS;
import utils.files;
import win7pecore.Shortcuts;
import win7pecore.WinPeLibrary;

public class Plugins {
    File pluginFolder = null;
    File pluginCache = common.getFolderCache();
    File localSourceFolder = null;
    File localTargetFolder = null;
    File settingsFile = null;
    String category = "";
    String pluginName = "";
    String pluginID = "";
    String pluginSubString = "";
    String pluginType = "";
    Settings settings = null;
    boolean isLogged = false;
    boolean runFromRAM = true;
    Shortcuts shortcutLib = null;
    File thisFile = null;
    File targetDirFile;
    File cdDirFile;
    File winDirFolder;
    File winSysFolder;
    File targetFile;
    WinPeLibrary peLib;

    public Plugins(String theName) {
        this.targetDirFile = Core.sys.build.folderPeWIM;
        this.cdDirFile = Core.sys.build.folderBase;
        this.winDirFolder = null;
        this.winSysFolder = null;
        this.targetFile = null;
        this.peLib = new WinPeLibrary();
        this.pluginFolder = common.getFolderCore();
        this.settingsFile = new File(this.pluginFolder, theName + ".xml");
        this.pluginsFromConfig(this.settingsFile, theName);
        this.pluginCommons();
        Core.temp.put("pluginSettings", this.settings);
    }

    public Plugins(File thisFile) {
        this.targetDirFile = Core.sys.build.folderPeWIM;
        this.cdDirFile = Core.sys.build.folderBase;
        this.winDirFolder = null;
        this.winSysFolder = null;
        this.targetFile = null;
        this.peLib = new WinPeLibrary();
        this.thisFile = thisFile;
        this.pluginsFromMain();
        this.pluginCommons();
        Core.temp.put("pluginSettings", this.settings);
    }

    private void pluginCommons() {
        this.winDirFolder = new File(this.targetDirFile, "Windows");
        this.winSysFolder = new File(this.winDirFolder, "System32");
        if (this.settings != null) {
            this.settings.write("ID", this.pluginID);
            this.pluginType = this.settings.read("!Type");
            this.pluginName = this.settings.read("!Name");
            this.category = this.settings.read("!Category");
            this.runFromRAM = this.settings.read("RunFromRAM", "True").equalsIgnoreCase("True");
            this.targetFile = this.runFromRAM ? Core.sys.build.folderPeWIM : Core.sys.build.folderBase;
            File localPluginDir = common.getFolderPlugins();
            if (this.category != null) {
                String localDir;
                File pluginSubDir = new File(localPluginDir.getName(), this.category);
                pluginSubDir = new File(pluginSubDir, this.pluginName);
                this.pluginSubString = pluginSubDir.toString();
                String tmp = this.settings.read("TargetFolder");
                if ("$Default".equals(tmp)) {
                    this.localTargetFolder = new File(this.targetFile, this.pluginSubString);
                } else if (tmp != null && tmp.startsWith("$Programs")) {
                    File programsDir = new File(this.targetFile, "Program Files");
                    int p = tmp.lastIndexOf("\\");
                    this.localTargetFolder = new File(programsDir, tmp.substring(p + 1));
                } else if (tmp != null && tmp.startsWith("$WinSys")) {
                    File winDir = new File(this.targetFile, "Windows");
                    this.localTargetFolder = new File(winDir, "System32");
                } else if (tmp != null) {
                    this.localTargetFolder = new File(tmp);
                }
                if (this.localTargetFolder != null && !this.localTargetFolder.exists()) {
                    files.mkdirs(this.localTargetFolder);
                }
                if ("$Default".equals(localDir = this.settings.read("LocalFolder"))) {
                    this.localSourceFolder = new File(localPluginDir.getParentFile(), this.pluginSubString);
                } else if (localDir != null) {
                    this.localSourceFolder = new File(localDir);
                }
                if (this.localSourceFolder != null && !this.localSourceFolder.exists()) {
                    files.mkdirs(this.localSourceFolder);
                }
                this.shortcutLib = new Shortcuts(this.settings.getSettingsFile());
                this.shortcutLib.setPeLib(this.peLib);
                this.shortcutLib.getInfo();
            }
            this.processAutoStart();
        }
    }

    private void getSettings() {
        this.settingsFile = new File(this.pluginCache, "settings-" + this.pluginID + ".xml");
        if (!this.settingsFile.exists()) {
            File oriSettingsFile = new File(this.pluginFolder, "settings.xml");
            files.copyFile(oriSettingsFile, this.settingsFile);
        }
        this.settings = new Settings(this.settingsFile, "Settings for " + this.pluginName);
    }

    private File getTagExe() {
        return new File(this.localSourceFolder, this.shortcutLib.getLinkExe());
    }

    private void pluginsFromMain() {
        this.pluginFolder = this.thisFile.getParentFile().getAbsoluteFile();
        String folderName = this.pluginFolder.getName();
        int p = folderName.indexOf("-");
        if (p != 0) {
            this.pluginID = folderName.substring(0, p);
            this.pluginName = folderName.substring(p + 1);
        }
        this.getSettings();
    }

    private void pluginsFromConfig(File thisFile, String theName) {
        this.pluginName = theName.contains(".") ? theName.substring(0, theName.indexOf(".")) : theName;
        if (thisFile.exists()) {
            this.settingsFile = thisFile;
            this.settings = new Settings(this.settingsFile, "Settings for " + this.pluginName);
        }
    }

    public void logInstall() {
        String tp = this.pluginType.toUpperCase();
        int action = !tp.equals("CORE") ? 500 : 507;
        log.write(action, "%1: %2", tp, this.pluginName);
    }

    public void createShortcuts() {
        if (this.shortcutLib != null) {
            this.shortcutLib.createShortcuts();
        }
    }

    public void createAssocs(RegHeader header) {
        if (this.shortcutLib != null) {
            this.shortcutLib.createAssocs(header);
        }
    }

    public void doOpenWith(RegHeader header) {
        if (this.shortcutLib != null) {
            this.shortcutLib.doOpenWith(header);
        }
    }

    public boolean copyApp() {
        if (!this.isLogged) {
            this.logInstall();
            this.isLogged = true;
        }
        try {
            return this.install();
        }
        catch (ExtractSevenZip.ExtractionException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public boolean downloadApp() {
        return this.peLib.download(this.settings, this.pluginFolder);
    }

    public boolean checkReadme() {
        File readMe = new File(this.pluginFolder, "Readme.txt");
        if (readMe.exists()) {
            try {
                FileInputStream fis = new FileInputStream(readMe);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith(";")) {
                        line = line.replace("$plugin$", this.pluginName);
                        line = line.replace("$target$", this.localSourceFolder.getAbsolutePath());
                        File theDownloaded = (File)Core.temp.get("theDownloaded");
                        if (theDownloaded != null) {
                            line = line.replace("$down$", theDownloaded.getAbsolutePath());
                        }
                        log.write(30, line);
                    }
                    line = reader.readLine();
                }
                files.mkdirs(this.localSourceFolder);
            }
            catch (IOException ex) {
                Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }
        return false;
    }

    public boolean checkPlugin(String theName) {
        boolean result = false;
        Class<?> theClass = null;
        try {
            theClass = Class.forName("win7pecore.corebuild." + theName);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (theClass == null) {
            try {
                theClass = Class.forName("win7pecore.components." + theName);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            if (theClass == null) {
                try {
                    theClass = Class.forName("win7pecore.filescollections." + theName);
                }
                catch (ClassNotFoundException ex) {
                    String message = "Class " + theName + " not found!";
                    log.write(34, message);
                    return false;
                }
            }
        }
        try {
            Object theObject = theClass.newInstance();
            Method method = theClass.getDeclaredMethod("pluginCode", new Class[0]);
            method.invoke(theObject, new Object[0]);
            result = true;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public boolean checkCache(String theName) {
        Class<?> theClass;
        boolean result = false;
        try {
            theClass = Class.forName("win7pecore.filescollections." + theName);
        }
        catch (ClassNotFoundException ex) {
            String message = "Class " + theName + " not found!";
            log.write(34, message);
            return false;
        }
        try {
            Object theObject = theClass.newInstance();
            Method method = theClass.getDeclaredMethod("pluginCode", new Class[0]);
            method.invoke(theObject, new Object[0]);
            result = true;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(WinPeLibrary.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private void processAutoStart() {
        String auto;
        if (this.settings != null && !"None".equalsIgnoreCase(auto = this.settings.read("AutoStart", "None"))) {
            String cmd = this.settings.read("AutoStartCommand");
            if ("$Default".equals(cmd)) {
                cmd = this.shortcutLib.getPeExe().getPath();
            }
            if ("Boot".equalsIgnoreCase(auto)) {
                this.peLib.appendTextLine(new File(this.winSysFolder, "startboot.cmd"), cmd);
            } else if ("Logon".equalsIgnoreCase(auto)) {
                this.peLib.appendTextLine(new File(this.winSysFolder, "startlogon.cmd"), cmd);
            }
        }
    }

    String getOsPath(String thePath) {
        if (currentOS.isWindows()) {
            return thePath.replace("/", "\\");
        }
        return thePath.replace("\\", "/");
    }

    public boolean copyFile(String srcNam, String trgPath) {
        String osPath = this.getOsPath(trgPath);
        File targetFolder = new File(this.localTargetFolder, osPath);
        File trgFile = new File(targetFolder, srcNam);
        File sourceFile = new File(this.pluginFolder, srcNam);
        if (trgFile.exists()) {
            trgFile.delete();
        }
        return files.copyFile(sourceFile, trgFile);
    }

    public boolean deleteFile(String trgPath) {
        String osPath = this.getOsPath(trgPath);
        File targetFile = new File(this.localTargetFolder, osPath);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        return !targetFile.exists();
    }

    public boolean deleteDir(String trgPath) {
        String osPath = this.getOsPath(trgPath);
        File targetFolder = new File(this.localTargetFolder, osPath);
        if (targetFolder.exists()) {
            try {
                FileUtils.forceDelete(targetFolder);
            }
            catch (IOException ex) {
                Logger.getLogger(Plugins.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return !targetFolder.exists();
    }

    public File getTargetFolder() {
        return this.localTargetFolder;
    }

    public File getPluginPeFolder() {
        return this.shortcutLib.getPeExe().getParentFile();
    }

    public File getPluginPeExe() {
        return this.shortcutLib.getPeExe();
    }

    public File getPluginSourceFolder() {
        return this.localSourceFolder;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getPluginSettingsFileName() {
        return this.settingsFile.getPath();
    }

    public boolean install() throws ExtractSevenZip.ExtractionException, IOException {
        if (this.localTargetFolder == null) {
            return true;
        }
        Settings pluginSettings = this.settings;
        boolean useLocal = !this.peLib.getOptionBool(pluginSettings, "IsAttached");
        boolean copied = !useLocal;
        File theFile = new File(this.pluginFolder, "plugin_RAM.zip");
        if (theFile.exists()) {
            this.peLib.zipExtractAll(theFile, this.targetDirFile);
            boolean bl = copied = !useLocal;
        }
        if ((theFile = new File(this.pluginFolder, "plugin_CD.zip")).exists()) {
            this.peLib.zipExtractAll(theFile, this.cdDirFile);
            boolean bl = copied = !useLocal;
        }
        if ((theFile = new File(this.pluginFolder, "plugin_APP.zip")).exists()) {
            this.peLib.zipExtractAll(theFile, this.localTargetFolder);
            boolean bl = copied = !useLocal;
        }
        if (useLocal) {
            File tagExe = this.getTagExe();
            if (tagExe.exists()) {
                files.copyFolder(this.localSourceFolder, this.localTargetFolder);
                copied = true;
            } else if (!this.checkReadme()) {
                log.write(-1, "Missing, empty or invalid application folder: %1", this.localSourceFolder.getPath());
            }
        }
        return copied;
    }
}

