/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import bsh2java.log;
import build.Core;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.RegHeader;
import utils.files;
import win7pecore.Win7PE;

public class Hives {
    public RegHeader systemHive = null;
    public RegHeader defaultHive = null;
    public RegHeader softwareHive = null;

    private RegHeader openHive(File hiveFile) {
        RegHeader result = new RegHeader(hiveFile.getAbsolutePath());
        result.open();
        result.setAutoCreateKey(true);
        result.setAllowValOverwrite(RegHeader.AllowOverwrite.TRUE);
        return result;
    }

    public void copyHives(File targetDir) {
        this.copyHive(this.systemHive, targetDir);
        this.copyHive(this.defaultHive, targetDir);
        this.copyHive(this.softwareHive, targetDir);
    }

    private void copyHive(RegHeader hive, File targetDir) {
        File srcHive = new File(hive.getFilePath());
        File trgHive = new File(targetDir, hive.getHiveName());
        if (trgHive.exists()) {
            trgHive.delete();
        }
        files.copyFile(srcHive, trgHive);
    }

    public boolean open(Win7PE win7pe) {
        File config = new File(win7pe.targetWinSysFolder, "config");
        return this.open(win7pe, config);
    }

    public boolean open(Win7PE win7pe, File config) {
        File sysHive = new File(config, "SYSTEM");
        if (!sysHive.exists()) {
            return false;
        }
        this.systemHive = this.openHive(sysHive);
        File sftHive = new File(config, "SOFTWARE");
        if (!sftHive.exists()) {
            return false;
        }
        this.softwareHive = this.openHive(sftHive);
        File defHive = new File(config, "DEFAULT");
        if (!defHive.exists()) {
            return false;
        }
        this.defaultHive = this.openHive(defHive);
        return true;
    }

    private void closeHive(RegHeader hive) throws IOException {
        hive.commit();
        hive.release();
    }

    public void closeHives() {
        try {
            boolean projectHivesExist = Boolean.parseBoolean((String)Core.temp.get("projectHivesExist"));
            if (projectHivesExist) {
                log.write(509, "Target registry hives");
            }
            this.closeHive(this.systemHive);
            this.closeHive(this.softwareHive);
            this.closeHive(this.defaultHive);
            System.gc();
        }
        catch (IOException ex) {
            Logger.getLogger(Hives.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

