/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import inifiles.IniFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import relink.MSlink;
import utils.files;
import win7pecore.Shortcuts;
import win7pecore.Win7PE;
import win7pecore.components.VSS;

public class CustomShortcut {
    File target;
    Win7PE winpe;
    ArrayList<SingleShortcut> shortcuts;
    File targetFile;
    File peFile;
    SingleShortcut actShortcut;

    public CustomShortcut(Win7PE pe) {
        this.winpe = pe;
        this.target = new File(this.winpe.targetWinSysFolder, "config");
        this.target = new File(this.target, "systemprofile");
        this.target = new File(this.target, "DeskTop");
        this.shortcuts = new ArrayList();
    }

    public void addFolder(String drive, String name, int index) {
        MSlink newLink = new MSlink();
        newLink.setTarget("X:\\Windows\\explorer.exe", false);
        newLink.setArguments("/root," + drive + "\\" + name);
        String tmp = name.toUpperCase();
        String linkName = tmp.replace("USER", "UserFolder").concat(".lnk");
        File peWinSysFolder = new File(new File("X:"), "Windows");
        peWinSysFolder = new File(peWinSysFolder, "System32");
        String iconFileName = new File(peWinSysFolder, "shell32.dll").getAbsolutePath().replace("/", "\\");
        newLink.setIcon(iconFileName);
        newLink.setIconIndex(index);
        newLink.setShowWindowMode(1);
        File linkFile = new File(this.target, linkName);
        if (!this.target.exists()) {
            files.mkdirs(this.target);
        }
        newLink.save(linkFile);
    }

    public void add(String pluginName, String exePath, String caption, String linkFile) {
        String iconName = null;
        String peTargetExe = "X:\\Windows\\System32\\" + exePath;
        this.targetFile = new File(this.winpe.targetWinSysFolder, exePath);
        if (pluginName != null && this.winpe.winPeLibrary.unZipResource(pluginName + "/" + caption + ".zip", this.winpe.targetWinSysFolder)) {
            iconName = "X:\\Windows\\System32\\" + caption + ".ico";
        }
        this.actShortcut = new SingleShortcut(this.targetFile, peTargetExe, caption, linkFile, iconName);
        this.shortcuts.add(this.actShortcut);
    }

    public void write(String[] list) {
        IniFile batch = new IniFile(this.targetFile);
        for (String entry : list) {
            batch.lineInsert(entry + "\r");
        }
        try {
            batch.closeFile();
        }
        catch (IOException ex) {
            Logger.getLogger(VSS.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clean() {
        this.shortcuts.clear();
    }

    public void apply() {
        int count = this.shortcuts.size();
        for (int i = 0; i < count; ++i) {
            this.generateShortcut(this.shortcuts.get(i));
        }
    }

    private void generateShortcut(SingleShortcut shortcut) {
        File dir2;
        MSlink newLink = new MSlink();
        String sep = System.getProperty("file.separator");
        String trg = shortcut.shortcutExePath.replace(sep, "\\");
        String lnk = shortcut.shortcutLinkFile.replace(sep, "\\");
        newLink.setTarget(trg, false);
        String theCaption = this.winpe.projectSettings.getProperties().getProperty("ShortcutCaption");
        if ("Description".equalsIgnoreCase(theCaption)) {
            String theName = Shortcuts.getDescription(shortcut.buildExe);
            if (theName != null) {
                lnk = theName.concat(".lnk");
            } else {
                String mainName = shortcut.shortcutCaption;
                String nativeName = null;
                if (mainName != null) {
                    if (mainName.startsWith("@")) {
                        File localTargetFolder = this.actShortcut.buildExe.getParentFile();
                        nativeName = Shortcuts.getDescription(new File(localTargetFolder, mainName.substring(1)));
                        if (nativeName != null) {
                            lnk = nativeName.concat(".lnk");
                        }
                    } else {
                        lnk = mainName.concat(".lnk");
                    }
                } else {
                    lnk = shortcut.buildExe.getName().replace(".exe", "").concat(".lnk");
                }
            }
        }
        if (shortcut.shortcutIconName != null) {
            newLink.setIcon(shortcut.shortcutIconName);
        }
        if (!(dir2 = this.target.getAbsoluteFile()).exists()) {
            files.mkdirs(dir2);
        }
        File linkFile = new File(dir2, lnk);
        newLink.save(linkFile);
    }

    protected class SingleShortcut {
        private final String shortcutExePath;
        private final String shortcutCaption;
        private final String shortcutLinkFile;
        private final String shortcutIconName;
        private final File buildExe;

        protected SingleShortcut(File exe, String exePath, String caption, String link, String iconName) {
            this.buildExe = exe;
            this.shortcutExePath = exePath;
            this.shortcutCaption = caption != null ? caption : "";
            this.shortcutLinkFile = link;
            this.shortcutIconName = iconName;
        }
    }
}

