/*
 * Decompiled with CFR 0.152.
 */
package win7pecore;

import bsh2java.log;
import build.Core;
import downloads.common;
import java.io.File;
import rewim.WimExtractorEx;
import utils.files;
import win7pecore.Win7PE;

public class ArchiveWIM {
    public WimExtractorEx install = null;
    public WimExtractorEx winre = null;
    public WimExtractorEx boot = null;
    Win7PE winpe = null;

    public ArchiveWIM(Win7PE winpe) {
        this.winpe = winpe;
    }

    public void createSkeleton() {
        String sourceLanguage = this.winpe.coreSource.defaultLanguage;
        this.createFolderWIM(this.winpe.targetWinFolder, sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinFolder, "Fonts");
        this.createFolderWIM(this.winpe.targetWinFolder, "Globalization", "Sorting");
        this.createFolderWIM(this.winpe.targetWinFolder, "inf", sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinSysFolder, sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinSysFolder, "Boot", sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinSysFolder, "config", "systemprofile");
        this.createFolderWIM(this.winpe.targetWinSysFolder, "drivers", sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinFolder, "winsxs", "Manifests");
        this.createFolderWIM(this.winpe.targetWinFolder, "AppPatch", sourceLanguage);
        this.createFolderWIM(this.winpe.targetWinFolder, "L2Schemas");
        this.createFolderWIM(this.winpe.targetWinFolder, "Provisioning", "schemas", "AvailableNetwork");
    }

    public void setTime(File folder, long time2) {
        File[] files2;
        for (File file : files2 = folder.listFiles()) {
            if (file.isDirectory()) {
                this.setTime(file, time2);
            }
            file.setLastModified(time2);
        }
        folder.setLastModified(time2);
    }

    public void createFolderWIM(File parent, String child) {
        File folder = new File(parent, child);
        files.mkdirs(folder);
    }

    public void createFolderWIM(File parent, String firstChild, String secondChild) {
        this.createFolderWIM(new File(parent, firstChild), secondChild);
    }

    public void createFolderWIM(File parent, String firstChild, String secondChild, String thirdChild) {
        this.createFolderWIM(new File(parent, firstChild), secondChild, thirdChild);
    }

    public void open() {
        log.write(508, "Source WIM archives");
        try {
            String tmp = this.winpe.wbSettings.read("wimIndexInstall", "1");
            int wimIndexInstall = Integer.parseInt(tmp);
            this.install = new WimExtractorEx(this.winpe.coreSource.getFileWimInstall().getAbsolutePath(), wimIndexInstall);
            this.install.setSourceLanguage(this.winpe.coreSource.defaultLanguage);
            tmp = this.winpe.wbSettings.read("wimIndexBoot", "2");
            int wimIndexBoot = Integer.parseInt(tmp);
            this.boot = new WimExtractorEx(this.winpe.coreSource.getFileWimBoot().getAbsolutePath(), wimIndexBoot);
            this.boot.setSourceLanguage(this.winpe.coreSource.defaultLanguage);
            String rw = "winRE_" + Core.sys.source.defaultLanguage + "_" + Core.sys.source.build + ".wim";
            File reWim = new File(common.getFolderCore(), rw);
            if (!reWim.exists()) {
                File reDir = new File(this.winpe.targetWinSysFolder, "Recovery");
                if (!reDir.exists()) {
                    files.mkdirs(reDir);
                }
                File reFile = new File(reDir, "winRE.wim");
                this.install.extractFile("Windows\\System32\\Recovery\\winRE.wim");
                files.copyFile(reFile, reWim);
                reFile.delete();
                reDir.delete();
            }
            this.winre = new WimExtractorEx(reWim.getAbsolutePath(), 1);
            this.winre.setSourceLanguage(this.winpe.coreSource.defaultLanguage);
        }
        catch (NumberFormatException e) {
            log.write(-1, "Exception: %1", e.getMessage());
        }
    }

    public void releaseSourceWims() {
        log.write(509, "Source WIM archives");
        if (this.boot != null) {
            this.boot.release();
        }
        if (this.install != null) {
            this.install.release();
        }
        if (this.winre != null) {
            this.winre.release();
        }
    }
}

