/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import vhd.BlockAllocationTable;
import vhd.DataBlock;
import vhd.VHDFooter;
import vhd.VHDHeader;

public class VHDImage {
    public static final int VHD_HEADER_SIZE = 1024;
    public static final int VHD_FOOTER_SIZE = 512;
    public static final int VHD_SECTOR_SIZE = 512;
    private VHDFooter copyFooter;
    private VHDHeader header;
    private BlockAllocationTable table;
    private VHDFooter footer;
    private FileChannel srcChannel;
    private final String imageLocation;
    private final boolean isCreate;

    public static void main(String[] args) throws IOException {
        VHDImage image = new VHDImage("C:\\Users\\Owner\\Desktop\\vhd\\Windows XP.vhd");
        image.parse();
    }

    public VHDImage(String imageLocation) throws IOException {
        this(imageLocation, false);
    }

    public VHDImage(String imageLocation, boolean create) throws IOException {
        this.imageLocation = imageLocation;
        this.isCreate = create;
        File srcFile = new File(imageLocation);
        if (create) {
            srcFile.mkdirs();
            srcFile.createNewFile();
        }
        this.srcChannel = new FileInputStream(srcFile).getChannel();
        this.parse();
    }

    public void save() {
    }

    private void parse() throws IOException {
        MappedByteBuffer buff = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 512L);
        buff.order(ByteOrder.BIG_ENDIAN);
        this.copyFooter = new VHDFooter(buff);
        if (this.copyFooter.hasHeader()) {
            buff = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, this.copyFooter.getDataOffset(), 1024L);
            buff.order(ByteOrder.BIG_ENDIAN);
            this.header = new VHDHeader(buff);
            this.table = new BlockAllocationTable(this.srcChannel, this.header.getTableOffset(), this.header.getMaxTableEntries(), this.header.getBlockSize());
            DataBlock block = this.table.getDataBlocks().get(0);
            byte[] data = block.getData();
            System.out.println(new String(data));
        }
    }
}

