/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import vhd.ParentLocatorEntry;
import vhd.VHDUtils;

public class VHDHeader {
    private String cookie;
    private long dataOffset;
    private long tableOffset;
    private float headerVersion;
    private int maxTableEntries;
    private int blockSize;
    private int checksum;
    private byte[] uuid;
    private int parentTimeStamp;
    private String parentUnicodeName;
    private ParentLocatorEntry[] parentLocatorEntries;

    public VHDHeader(ByteBuffer buff) {
        byte[] cookieData = new byte[8];
        buff.get(cookieData);
        this.cookie = new String(cookieData);
        this.dataOffset = buff.getLong();
        this.tableOffset = buff.getLong();
        this.headerVersion = VHDUtils.toFloat(buff.getShort(), buff.getShort());
        this.maxTableEntries = buff.getInt();
        this.blockSize = buff.getInt();
        this.checksum = buff.getInt();
        this.uuid = new byte[16];
        buff.get(this.uuid);
        this.parentTimeStamp = buff.getInt();
        buff.getInt();
        byte[] parentUnicodeNameData = new byte[512];
        buff.get(parentUnicodeNameData);
        try {
            this.parentUnicodeName = new String(parentUnicodeNameData, "UTF-16").trim();
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        this.parentLocatorEntries = new ParentLocatorEntry[8];
        for (int i = 0; i < this.parentLocatorEntries.length; ++i) {
            this.parentLocatorEntries[i] = new ParentLocatorEntry(buff);
        }
    }

    public String getCookie() {
        return this.cookie;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getTableOffset() {
        return this.tableOffset;
    }

    public float getHeaderVersion() {
        return this.headerVersion;
    }

    public int getMaxTableEntries() {
        return this.maxTableEntries;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public String getUuid() {
        return VHDUtils.toUUIDFormat(this.uuid);
    }

    public int getParentTimeStamp() {
        return this.parentTimeStamp;
    }

    public String getParentUnicodeName() {
        return this.parentUnicodeName;
    }

    public ParentLocatorEntry[] getParentLocatorEntries() {
        return this.parentLocatorEntries;
    }
}

