/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import java.nio.ByteBuffer;
import vhd.DiskGeometry;
import vhd.VHDUtils;

public class VHDFooter {
    public static final int OS_WINDOWS = 1466511979;
    public static final int OS_MACINTOSH = 1298228000;
    public static final int FIXED_HARD_DISK_TYPE = 2;
    public static final int DYNAMIC_HARD_DISK_TYPE = 3;
    public static final int DIFFERENCING_HARD_DISK_TYPE = 4;
    private String cookie;
    private int features;
    private float formatVersion;
    private long dataOffset;
    private int timeStamp;
    private String creatorApplication;
    private float creatorVersion;
    private int creatorOS;
    private long originalSize;
    private long currentSize;
    private DiskGeometry diskGeometry;
    private int diskType;
    private int checksum;
    private byte[] uuid;
    private int savedState;

    public VHDFooter(ByteBuffer buff) {
        byte[] cookieData = new byte[8];
        buff.get(cookieData);
        this.cookie = new String(cookieData);
        this.features = buff.getInt();
        this.formatVersion = VHDUtils.toFloat(buff.getShort(), buff.getShort());
        this.dataOffset = buff.getLong();
        this.timeStamp = buff.getInt();
        byte[] creatorData = new byte[4];
        buff.get(creatorData);
        this.creatorApplication = new String(creatorData);
        this.creatorVersion = VHDUtils.toFloat(buff.getShort(), buff.getShort());
        this.creatorOS = buff.getInt();
        this.originalSize = buff.getLong();
        this.currentSize = buff.getLong();
        byte[] diskGeometryData = new byte[4];
        buff.get(diskGeometryData);
        this.diskGeometry = new DiskGeometry(diskGeometryData);
        this.diskType = buff.getInt();
        this.checksum = buff.getInt();
        this.uuid = new byte[16];
        buff.get(this.uuid);
        this.savedState = buff.get();
    }

    public boolean hasHeader() {
        return this.diskType == 3 || this.diskType == 4;
    }

    public boolean isWindows() {
        return this.creatorOS == 1466511979;
    }

    public boolean isMac() {
        return this.creatorOS == 1298228000;
    }

    public String getCookie() {
        return this.cookie;
    }

    public int getFeatures() {
        return this.features;
    }

    public float getFormatVersion() {
        return this.formatVersion;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public String getCreatorApplication() {
        return this.creatorApplication;
    }

    public float getCreatorVersion() {
        return this.creatorVersion;
    }

    public int getCreatorOS() {
        return this.creatorOS;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    public DiskGeometry getDiskGeometry() {
        return this.diskGeometry;
    }

    public int getDiskType() {
        return this.diskType;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public String getUuid() {
        return VHDUtils.toUUIDFormat(this.uuid);
    }

    public int getSavedState() {
        return this.savedState;
    }
}

