/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import relink.utils.Utils;
import vhd.InvalidVHDException;

public class DiskGeometry {
    private int cylinderCount;
    private int headCount;
    private int sectorsPerTrack;

    public DiskGeometry() {
    }

    public DiskGeometry(byte[] data) {
        if (data.length != 4) {
            throw new InvalidVHDException("Invalid disk geometry data");
        }
        this.cylinderCount = Utils.toInt16(data, 0);
        this.headCount = data[2] & 0xFF;
        this.sectorsPerTrack = data[3] & 0xFF;
    }

    public int getCylinderCount() {
        return this.cylinderCount;
    }

    public void setCylinderCount(int cylinderCount) {
        this.cylinderCount = cylinderCount;
    }

    public int getHeadCount() {
        return this.headCount;
    }

    public void setHeadCount(int headCount) {
        this.headCount = headCount;
    }

    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    public void setSectorsPerTrack(int sectorsPerTrack) {
        this.sectorsPerTrack = sectorsPerTrack;
    }
}

