/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import vhd.Byteable;

public class DataBlock
implements Byteable {
    private FileChannel srcChannel;
    private int blockSize;
    private long offset;
    private byte[] sectorBitmap;
    private byte[] data;

    public DataBlock(FileChannel srcChannel, long offset, int blockSize) {
        this.offset = offset;
        this.srcChannel = srcChannel;
        this.blockSize = blockSize;
    }

    public byte[] getSectorBitmap() throws IOException {
        this.sectorBitmap = new byte[512];
        MappedByteBuffer buff = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, this.offset, 512L);
        buff.get(this.sectorBitmap);
        return this.sectorBitmap;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(this.sectorBitmap.length + this.data.length);
        bb.put(this.sectorBitmap == null ? this.getSectorBitmap() : this.sectorBitmap);
        bb.put(this.data == null ? this.getData() : this.data);
        return bb.array();
    }

    public byte[] getData() throws IOException {
        this.data = new byte[this.blockSize];
        MappedByteBuffer buff = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, this.offset + 512L, this.blockSize);
        buff.get(this.data);
        return this.data;
    }
}

