/*
 * Decompiled with CFR 0.152.
 */
package vhd;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import vhd.DataBlock;

public class BlockAllocationTable {
    private FileChannel srcChannel;
    private long offset;
    private int entries;
    private int blockSize;
    private ArrayList<DataBlock> dataBlocks;

    public BlockAllocationTable(FileChannel srcChannel, long offset, int entries, int blockSize) {
        this.srcChannel = srcChannel;
        this.offset = offset;
        this.entries = entries;
        this.blockSize = blockSize;
        this.dataBlocks = new ArrayList();
        try {
            this.parse();
        }
        catch (IOException ex) {
            Logger.getLogger(BlockAllocationTable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parse() throws IOException {
        MappedByteBuffer buff = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, this.offset, this.entries * 4);
        buff.order(ByteOrder.BIG_ENDIAN);
        long fullBatSize = this.offset + (long)(this.entries * 4);
        for (int i = 0; i < this.entries; ++i) {
            int dbOffset = buff.getInt();
            if (dbOffset == -1) continue;
            this.dataBlocks.add(new DataBlock(this.srcChannel, (long)dbOffset + fullBatSize, this.blockSize));
        }
    }

    public ArrayList<DataBlock> getDataBlocks() {
        return this.dataBlocks;
    }
}

