/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utils.Base64;
import utils.files;

public class text {
    public static String findRegEx(String source, String reg, int group) {
        String out = null;
        Pattern p = Pattern.compile(reg);
        Matcher matcher = p.matcher(source);
        if (matcher.find()) {
            try {
                out = matcher.group(group);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return out;
    }

    public static String generateStringMD5(String content) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(files.class.getName()).log(Level.SEVERE, null, ex);
        }
        md.update(content.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String generateStringSHA256(String content) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(files.class.getName()).log(Level.SEVERE, null, ex);
        }
        md.update(content.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String safeString(String input) {
        input = input.replace("<", "");
        input = input.replace(">", "");
        input = input.replace("%", "");
        input = input.replace(";", "");
        String output = text.findRegEx(input, "[a-zA-Z0-9-_@\\.]+$", 0);
        return output;
    }

    public static String propertiesToString(Properties message) {
        String result = "";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            message.storeToXML(output, "");
            result = Base64.encodeBytes(output.toByteArray(), 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Properties stringToProperties(String message) {
        byte[] temp;
        Properties result = new Properties();
        if (message.equalsIgnoreCase("")) {
            return null;
        }
        try {
            temp = Base64.decode(message);
        }
        catch (IOException ex) {
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(temp);
            if (in == null) {
                return null;
            }
            result.loadFromXML(in);
        }
        catch (IOException ex) {
            return null;
        }
        return result;
    }

    public static String safeHTML(String input) {
        String output = input;
        output = output.replace("<", "");
        output = output.replace(">", "");
        output = output.replace("%", "");
        output = output.replace(";", "");
        output = output.replace("\"", "");
        output = output.replace("'", "");
        return output;
    }

    public static String encodeBase64(String input) {
        return Base64.encodeBytes(input.getBytes());
    }

    public static String decodeBase64(String input) {
        String result;
        try {
            result = new String(Base64.decode(input));
        }
        catch (IOException ex) {
            result = "";
        }
        return result;
    }

    public static String arrayToString(String[] a, String separator) {
        StringBuilder result = new StringBuilder();
        if (a.length > 0) {
            result.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                result.append(separator);
                result.append(a[i]);
            }
        }
        return result.toString();
    }

    public static int arrayIndex(String find, String[] fields) {
        int result = -1;
        int count = 0;
        for (String field : fields) {
            if (field.equalsIgnoreCase(find)) {
                return count;
            }
            ++count;
        }
        return result;
    }

    public static Boolean isEmpty(String input) {
        Boolean result = input == null || input.length() == 0;
        return result;
    }

    public static String shortText(String text2, int maxLength) {
        String result = text2;
        if (text2.length() > maxLength) {
            int half = maxLength / 2;
            int length = text2.length();
            result = text2.substring(0, half) + ".." + text2.substring(length - half, length);
        }
        return result;
    }

    public static String doFormat(String title, String value) {
        return title + " = " + value + "; ";
    }

    public static String getHex(String title, int value) {
        String result = Integer.toHexString(value);
        return text.doFormat(title, "0x" + result.toUpperCase());
    }

    public static String getHex(String title, long value) {
        String result = Long.toHexString(value);
        return text.doFormat(title, "0x" + result.toUpperCase());
    }

    public static String[] stringArrayAdd(String[] input, String newText) {
        String result = "";
        for (String current : input) {
            if (current.length() <= 0) continue;
            result = result.concat(current + ";");
        }
        result = result.concat(newText + ";");
        return result.split(";");
    }

    public static String[] stringArrayRemove(String[] input, String removeText) {
        String result = "";
        for (String current : input) {
            if (current.equalsIgnoreCase(removeText)) continue;
            result = result.concat(current + ";");
        }
        return result.split(";");
    }

    public static String[] stringPrune(String[] input) {
        String result = "";
        for (String current : input) {
            if (current.isEmpty()) continue;
            result = result.concat(current + ";");
        }
        return result.split(";");
    }

    public static String convertRecordToString(String[] record) {
        String result = "";
        for (String field : record) {
            result = result.concat(field + ";");
        }
        result = result.concat("\n");
        return result;
    }

    public static String[] stringClean(String[] input) {
        String result = "";
        for (String current : input) {
            if (current.isEmpty()) {
                result = result.concat(" ;");
                continue;
            }
            current = current.replace(";", ",");
            current = current.replace("\n", "");
            current = current.replace("\r", "");
            result = result.concat(current + ";");
        }
        return result.split(";");
    }

    public static String quickEncode(String input) {
        String result = input.replace(" ", "%20");
        result = result.replace("&", ".!.AND");
        result = result.replace("=", ".!.EQUAL");
        result = result.replace("/", ".!.fslash");
        result = result.replace("\\", ".!.bslash");
        result = result.replace("?", ".!.question");
        return result;
    }

    public static String quickDecode(String input) {
        String result = input.replace("%20", " ");
        result = result.replace(".!.AND", "&");
        result = result.replace(".!.EQUAL", "=");
        result = result.replace(".!.fslash", "/");
        result = result.replace(".!.bslash", "\\");
        result = result.replace(".!.question", "?");
        return result;
    }

    public static String getMultiple(String input, String filter) {
        String[] split = input.split("&");
        String result = "";
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].contains(filter)) continue;
            String snip = split[i].substring(split[i].indexOf("=") + 1);
            snip = URLDecoder.decode(snip);
            result = result.concat(snip + "|");
        }
        if (result.length() > 0) {
            result = "|" + result;
        }
        return result;
    }
}

