/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.apache.commons.io.FileUtils;
import utils.currentOS;

public class files {
    public static boolean isReady(File file) {
        try {
            if (!file.exists()) {
                return false;
            }
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            try {
                FileLock lock = channel.tryLock();
                lock.release();
                channel.close();
                return true;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public static void waitForReady(File file) {
        while (true) {
            try {
                while (true) {
                    boolean ok;
                    if (ok = files.isReady(file)) {
                        return;
                    }
                    Thread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputFileStreamToFile(InputStream inputStream, File outFile) {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            inputStream.close();
        }
        catch (IOException e) {
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ex) {}
        }
    }

    public static String getExtension(File file) {
        String filename = file.getName();
        if (!filename.contains(".")) {
            return "";
        }
        int mid = filename.lastIndexOf(".");
        String result = filename.substring(mid + 1, filename.length());
        result = result.toLowerCase();
        return result;
    }

    public static String readAsString(File file) {
        return new String(files.readAsBytes(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(File file) {
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        FileInputStream is2 = null;
        try {
            is2 = new FileInputStream(file);
            ((InputStream)is2).read(bytes);
        }
        catch (Exception e) {
        }
        finally {
            try {
                ((InputStream)is2).close();
            }
            catch (IOException ex) {}
        }
        return bytes;
    }

    public static List<String> readAsLines(File file) {
        String allText = files.readAsString(file);
        String[] lines = allText.split("\\r?\\n");
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(lines));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeAllBytes(File file, byte[] content) {
        FileOutputStream fos = null;
        boolean result = false;
        try {
            fos = new FileOutputStream(file);
            fos.write(content);
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(files.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(files.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                result = true;
            }
            catch (IOException ex) {
                Logger.getLogger(files.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static boolean deleteDir(File dir2) {
        if (dir2.isDirectory()) {
            String[] children = dir2.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = files.deleteDir(new File(dir2, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir2.delete();
    }

    public static long folderSize(File where) {
        ArrayList<File> folders = files.findFiles(where);
        long counter = 0L;
        for (File folder : folders) {
            counter += folder.length();
        }
        return counter;
    }

    public static ArrayList<File> findFiles(File where) {
        return files.findFiles(where, 25);
    }

    public static ArrayList<File> findFilesFiltered(File where, String what, int maxDeep) {
        File[] files2 = where.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (files2 != null) {
            for (File file : files2) {
                if (file.isFile()) {
                    if (!file.getName().contains(what)) continue;
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory() || maxDeep - 1 <= 0) continue;
                ArrayList<File> temp = files.findFilesFiltered(file, what, maxDeep - 1);
                for (File thisFile : temp) {
                    result.add(thisFile);
                }
            }
        }
        return result;
    }

    public static ArrayList<File> findFiles(File where, int maxDeep) {
        File[] files2 = where.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (files2 != null) {
            for (File file : files2) {
                if (file.isFile()) {
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory() || maxDeep - 1 <= 0) continue;
                ArrayList<File> temp = files.findFiles(file, maxDeep - 1);
                for (File thisFile : temp) {
                    result.add(thisFile);
                }
            }
        }
        return result;
    }

    public static long getFolderSize(File where, int maxDeep) {
        long result = 0L;
        ArrayList<File> files2 = files.findFiles(where, 25);
        for (File file : files2) {
            result += file.length();
        }
        return result;
    }

    public static ArrayList<File> findFolders(File where) {
        return files.findFolders(where, 25);
    }

    public static ArrayList<File> findFolders(File where, int maxDeep) {
        File[] files2 = where.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (files2 != null) {
            for (File file : files2) {
                if (!file.isDirectory() || maxDeep - 1 <= 0) continue;
                result.add(file);
                ArrayList<File> temp = files.findFolders(file, maxDeep - 1);
                for (File thisFile : temp) {
                    result.add(thisFile);
                }
            }
        }
        return result;
    }

    public static ArrayList<File> findAll(File where, int maxDeep) {
        File[] files2 = where.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (files2 != null) {
            for (File file : files2) {
                if (file.isFile()) {
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory() || maxDeep - 1 <= 0) continue;
                result.add(file);
                ArrayList<File> temp = files.findAll(file, maxDeep - 1);
                for (File thisFile : temp) {
                    result.add(thisFile);
                }
            }
        }
        return result;
    }

    public static ArrayList<File> findSubFolders(File where) {
        File[] files2 = where.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        if (files2 != null) {
            for (File file : files2) {
                if (!file.isDirectory()) continue;
                result.add(file);
            }
        }
        return result;
    }

    public static String humanReadableSize(Long size) {
        String output;
        long l = size;
        long MEGABYTE = 0x100000L;
        long KILOBYTE = 1024L;
        if (l > MEGABYTE) {
            long b = l / MEGABYTE;
            output = Long.toString(b) + " Mb";
        } else if (l > KILOBYTE) {
            long b = l / KILOBYTE;
            output = Long.toString(b) + " Kb";
        } else {
            output = size + " bytes";
        }
        return output;
    }

    public static synchronized String getDocumentsDirectory() {
        String result = "";
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser1 = new JFileChooser();
                String myresult = jFileChooser1.getFileSystemView().getDefaultDirectory().getAbsolutePath();
            }
        });
        return result;
    }

    public static synchronized String getDesktopDirectory() {
        JFileChooser jFileChooser1 = new JFileChooser();
        return jFileChooser1.getFileSystemView().getHomeDirectory().getAbsolutePath();
    }

    public static synchronized String getHomeDirectory() {
        JFileChooser jFileChooser1 = new JFileChooser();
        return jFileChooser1.getFileSystemView().getParentDirectory(jFileChooser1.getFileSystemView().createFileObject(files.getDesktopDirectory())).getAbsolutePath();
    }

    public static Boolean mkdirs(String folder) {
        File docs = new File(folder);
        boolean result = docs.mkdirs();
        return result;
    }

    public static Boolean mkdirs(File docs) {
        boolean result = docs.mkdirs();
        return result;
    }

    public static boolean touch(File folder, String file) {
        File touch = new File(folder, file);
        try {
            touch.createNewFile();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean SaveStringToFile(File inputFile, String inputString) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(inputFile));
            out.write(inputString);
            out.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deserializeString(File file) throws IOException {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        try (FileReader reader = new FileReader(file);){
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        return buffer.toString();
    }

    public static String[] getHotFolders() {
        String result = "";
        if (files.getDocumentsDirectory().length() > 0) {
            result = result.concat(files.getDocumentsDirectory()) + ";";
        }
        if (files.getDesktopDirectory().length() > 0) {
            result = result.concat(files.getDesktopDirectory()) + ";";
        }
        if (currentOS.isWindows()) {
            String home = files.getHomeDirectory();
            if (home.contains("\\Users")) {
                result = result.concat(home + "\\Downloads") + ";";
                result = result.concat(home + "\\Documents") + ";";
            }
        } else if (files.getHomeDirectory().length() > 0) {
            result = result.concat(files.getHomeDirectory()) + ";";
        }
        System.out.println("-->" + result);
        return result.split(";");
    }

    public static Boolean copyFile(File FromFile, File ToFile) {
        Boolean result = false;
        if (ToFile.exists() && FromFile.length() == ToFile.length()) {
            return true;
        }
        try {
            FileUtils.copyFile(FromFile, ToFile, true);
            result = ToFile.exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Boolean copyFolder(File FromFolder, File ToFolder) {
        Boolean result = true;
        try {
            FileUtils.copyDirectory(FromFolder, ToFolder, true);
        }
        catch (IOException ex) {
            result = false;
        }
        return result;
    }

    public static String getDate() {
        String result = "";
        try {
            Date date = files.getCompileTimeStamp(files.class);
            SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
            result = df.format(date);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Date getCompileTimeStamp(Class<?> cls) throws IOException {
        ClassLoader loader = cls.getClassLoader();
        String filename = cls.getName().replace('.', '/') + ".class";
        URL resource = loader != null ? loader.getResource(filename) : ClassLoader.getSystemResource(filename);
        URLConnection connection = resource.openConnection();
        long time2 = connection.getLastModified();
        return time2 != 0L ? new Date(time2) : null;
    }
}

