/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import utils.OS;

public class currentOS {
    public static OS find() {
        if (currentOS.isWindows()) {
            return OS.Windows;
        }
        if (currentOS.isUnix()) {
            return OS.Linux;
        }
        if (currentOS.isMac()) {
            return OS.Mac;
        }
        return OS.unknown;
    }

    public static void main(String[] args) {
        if (currentOS.isWindows()) {
            System.out.println("This is Windows");
        } else if (currentOS.isMac()) {
            System.out.println("This is Mac");
        } else if (currentOS.isUnix()) {
            System.out.println("This is Unix or Linux");
        } else {
            System.out.println("Your OS is not support!!");
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static String getRootFolders() {
        if (currentOS.isWindows()) {
            return currentOS.getWindowsDrives(true);
        }
        if (currentOS.isUnix()) {
            return "/";
        }
        if (currentOS.isMac()) {
            return "/";
        }
        return "";
    }

    public static String getRootFolder() {
        if (currentOS.isWindows()) {
            return "c:\\";
        }
        if (currentOS.isUnix()) {
            return "/";
        }
        if (currentOS.isMac()) {
            return "/";
        }
        return "";
    }

    public static String getWindowsDrives(boolean ignoreReadOnly) {
        File[] roots = File.listRoots();
        String result = "";
        for (File folder : roots) {
            if (!ignoreReadOnly) {
                result = result.concat(folder.getAbsolutePath() + ";");
                continue;
            }
            if (!folder.canWrite()) continue;
            result = result.concat(folder.getAbsolutePath() + ";");
        }
        result = result.substring(0, result.lastIndexOf(";"));
        return result;
    }
}

