/*
 * Decompiled with CFR 0.152.
 */
package utils;

import bsh2java.log;
import jBittorrentAPI_v1_0.Constants;
import jBittorrentAPI_v1_0.DownloadManager;
import jBittorrentAPI_v1_0.TorrentFile;
import jBittorrentAPI_v1_0.TorrentProcessor;
import jBittorrentAPI_v1_0.Utils;
import java.io.File;
import utils.internet;

public class Torrent {
    TorrentFile torrent;
    File torrentPath;
    File torrentDir;
    File oriName;
    File thePack;

    public Torrent(String url, File torrentDir, File outputDir) {
        this.torrentDir = torrentDir;
        this.torrentPath = new File(torrentDir, "x.torrent");
        if (this.torrentPath.exists()) {
            this.torrentPath.delete();
        }
        internet.downloadFile(url, this.torrentPath);
        TorrentProcessor tp = new TorrentProcessor();
        this.torrent = tp.getTorrentFile(tp.parseTorrent(this.torrentPath));
        this.oriName = new File(torrentDir, this.torrent.saveAs.replace(".7z", ".torrent"));
        if (this.oriName.exists()) {
            this.oriName.delete();
        }
        this.torrentPath.renameTo(this.oriName);
        Constants.SAVEPATH = outputDir.getAbsolutePath();
        this.thePack = new File(outputDir, this.torrent.saveAs);
    }

    public Torrent(File torrentPath, File outputDir) {
        this.torrentDir = torrentPath.getParentFile();
        TorrentProcessor tp = new TorrentProcessor();
        this.torrent = tp.getTorrentFile(tp.parseTorrent(torrentPath));
        Constants.SAVEPATH = outputDir.getAbsolutePath();
        this.thePack = new File(outputDir, this.torrent.saveAs);
    }

    public File getPack() {
        return this.thePack;
    }

    public void download() {
        if (this.torrent != null) {
            DownloadManager dm = new DownloadManager(this.torrent, Utils.generateID());
            dm.startListening(6881, 6889);
            log.write(30, "Accessing Tracker ...");
            dm.startTrackerUpdate();
            log.write(30, "Downloading %1 pieces ...", String.valueOf(this.torrent.piece_hash_values_as_binary.size()));
            dm.blockUntilCompletion();
            dm.stopTrackerUpdate();
            log.write(30, "Tracker left");
            dm.closeTempFiles();
        } else {
            System.err.println("Provided file is not a valid torrent file");
            System.err.flush();
            System.exit(1);
        }
    }
}

