/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.WbProperties;

public class Settings {
    private final WbProperties properties = new WbProperties();
    private final File settingsFile;
    private String comment = "";

    public Enumeration getAllKeys() {
        return this.properties.keys();
    }

    public Settings(File settingsFile, String comment) {
        this.settingsFile = settingsFile;
        this.comment = comment;
        if (settingsFile.exists()) {
            this.load();
        }
    }

    public void write(String key, String value) {
        this.properties.setProperty(key, value);
        this.save();
    }

    public void delete(String key) {
        this.properties.remove(key);
        this.save();
    }

    private boolean save() {
        try {
            FileOutputStream out = new FileOutputStream(this.settingsFile);
            this.properties.storeToXML(out, this.comment);
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private void load() {
        try {
            FileInputStream in = new FileInputStream(this.settingsFile);
            this.properties.loadFromXML(in);
            ((InputStream)in).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String read(String key) {
        return this.properties.getProperty(key);
    }

    public String read(String key, String alternative) {
        return this.properties.getProperty(key, alternative);
    }

    public Boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public static void main(String[] args) {
        Settings set = new Settings(new File("test1234.xml"), "testing the settings to see how they work");
        set.write("test", "1234");
        set.write("test1", "1234aas");
        set.write("test", "1234343");
        String test = set.read("test");
        if (!test.isEmpty()) {
            System.out.println(test);
        }
    }

    public WbProperties getProperties() {
        return this.properties;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }
}

