/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageConvert {
    BufferedImage image = null;

    public ImageConvert(File imageFile) {
        if (imageFile.exists()) {
            try {
                this.image = ImageIO.read(imageFile);
                this.resize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean writeImage(String newImage, String format) {
        boolean res = false;
        if (this.image != null) {
            File outImage = new File(newImage);
            if (outImage.exists()) {
                outImage.delete();
            }
            try {
                ImageIO.write((RenderedImage)this.image, format, outImage);
                res = true;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return res;
    }

    private void resize() throws IOException {
        float actRatio = (float)this.image.getWidth() / (float)this.image.getHeight();
        float ratio = 1.3333334f;
        if (actRatio != 1.3333334f) {
            int scaledHeight;
            int scaledWidth;
            if (actRatio > 1.3333334f) {
                scaledWidth = this.image.getWidth();
                scaledHeight = Math.round(actRatio / 1.3333334f * (float)this.image.getHeight());
            } else {
                scaledHeight = this.image.getHeight();
                scaledWidth = Math.round(actRatio / 1.3333334f * (float)this.image.getWidth());
            }
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, this.image.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(this.image, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            this.image = outputImage;
        }
    }

    public static void createColourBitMap(File picture, int width, int height, int red, int green, int blue) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graph = image.createGraphics();
        graph.setColor(new Color(red, green, blue));
        graph.fill(new Rectangle(0, 0, width, height));
        graph.dispose();
        try {
            ImageIO.write((RenderedImage)image, "BMP", picture);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageConvert.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void writeText(File picture, String[] lines, Color color, File logoFile) {
        try {
            BufferedImage img = ImageIO.read(picture);
            int paperWidth = img.getWidth();
            int paperHeight = img.getHeight();
            Graphics2D g2 = img.createGraphics();
            Font font = new Font("Dialog", 0, paperWidth / 53);
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            int stepY = metrics.getHeight() + 10;
            int nextY = paperHeight - 15;
            g2.setColor(color);
            for (int i = lines.length - 1; i >= 0; --i) {
                String line = lines[i];
                int adv = metrics.stringWidth(line);
                g2.drawString(line, paperWidth - adv - 10 - metrics.getAscent() - metrics.getDescent(), nextY);
                nextY -= stepY;
            }
            if (logoFile != null) {
                BufferedImage logo = ImageIO.read(logoFile);
                int logoWidth = logo.getWidth();
                int logoHeight = logo.getHeight();
                int xOrigin = paperWidth - 15 - logoWidth;
                int yOrigin = 15;
                int black = Color.BLACK.getRGB();
                for (int x = 0; x < logoWidth; ++x) {
                    for (int y = 0; y < logoHeight; ++y) {
                        int rgb = logo.getRGB(x, y);
                        if (rgb == black) continue;
                        img.setRGB(x + xOrigin, y + yOrigin, rgb);
                    }
                }
            }
            ImageIO.write((RenderedImage)img, "bmp", picture);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageConvert.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

