/*
 * Decompiled with CFR 0.152.
 */
package utils;

import bsh2java.log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import utils.ProgressTimer;
import utils.files;

public class ExtractSevenZip {
    private String archivePath;
    private String outputDirectory;
    private File archive;
    private File outputDirectoryFile;
    private String filterRegex;
    private ArchiveFormat archiveFormat = null;
    private boolean mergeOutput = true;
    private boolean logVerbose = false;
    private String dirPattern = null;
    String item = "";
    String password = "";
    ProgressTimer timer = null;

    public void setArchiveFormat(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setDir(String pattern) {
        this.dirPattern = pattern;
    }

    public void setLog(boolean mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public void setVerbose(boolean logVerbose) {
        this.logVerbose = logVerbose;
    }

    public void createTimer(long interval, int percentageStep) {
        this.timer = new ProgressTimer(this.archive.length(), this.outputDirectoryFile, interval, percentageStep);
    }

    public ExtractSevenZip(File archive, File outputDirectory, String filter) {
        this.archive = archive;
        this.outputDirectoryFile = outputDirectory;
        this.archivePath = archive.getAbsolutePath();
        this.outputDirectory = outputDirectory.getAbsolutePath();
        this.filterRegex = ExtractSevenZip.filterToRegex(filter);
    }

    public void extract() throws ExtractionException {
        if (this.timer != null) {
            this.timer.start();
        }
        this.checkArchiveFile();
        this.prepareOutputDirectory();
        this.extractArchive();
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void extract(String item) throws ExtractionException {
        this.item = item;
        this.extract();
    }

    public void extract(String item, String password) throws ExtractionException {
        this.item = item;
        this.password = password;
        this.extract();
    }

    private void prepareOutputDirectory() throws ExtractionException {
        this.outputDirectoryFile = new File(this.outputDirectory);
        if (!this.outputDirectoryFile.exists()) {
            this.outputDirectoryFile.mkdirs();
        } else if (this.outputDirectoryFile.list().length != 0 & !this.mergeOutput) {
            throw new ExtractionException("Output directory not empty: " + this.outputDirectory);
        }
    }

    private void checkArchiveFile() throws ExtractionException {
        if (!new File(this.archivePath).exists()) {
            throw new ExtractionException("Archive file not found: " + this.archivePath);
        }
        if (!new File(this.archivePath).canRead()) {
            String text2 = "Can't read archive file: " + this.archivePath;
            log.write(-1, text2);
        }
    }

    public void extractArchive() {
        try {
            boolean ok = false;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.archivePath, "r");
            this.extractArchive(randomAccessFile);
            randomAccessFile.close();
            boolean bl = true;
        }
        catch (Exception ex) {
            Logger.getLogger(ExtractSevenZip.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String filterToRegex(String filter) {
        if (filter == null) {
            return null;
        }
        return "\\Q" + filter.replace("*", "\\E.*\\Q") + "\\E";
    }

    private void extractArchive(RandomAccessFile file) throws ExtractionException, SevenZipException, FileNotFoundException, IOException {
        boolean ok = false;
        ISevenZipInArchive inArchive = SevenZip.openInArchive(this.archiveFormat, new RandomAccessFileInStream(file));
        if (!this.item.equals("")) {
            int index = 0;
            int count = inArchive.getNumberOfItems();
            for (int i = 0; i < count; ++i) {
                String pth = inArchive.getProperty(i, PropID.PATH).toString();
                if (!pth.equalsIgnoreCase(this.item)) continue;
                index = i;
                break;
            }
            File outFile = new File(this.outputDirectoryFile, this.item);
            files.mkdirs(outFile.getParentFile());
            ISimpleInArchive simpleInArchive = inArchive.getSimpleInterface();
            ISimpleInArchiveItem itm = simpleInArchive.getArchiveItem(index);
            SevenOutStream outStream = new SevenOutStream(outFile);
            if ("".equals(this.password)) {
                itm.extractSlow(outStream);
            } else {
                itm.extractSlow(outStream, this.password);
            }
            outStream.close();
        } else {
            int[] ids = null;
            if (this.filterRegex != null) {
                ids = ExtractSevenZip.filterIds(inArchive, this.filterRegex);
            } else if (this.dirPattern != null) {
                ids = ExtractSevenZip.filterDirs(inArchive, this.dirPattern);
            }
            inArchive.extract(ids, false, new ExtractCallback(inArchive));
        }
        ok = true;
        inArchive.close();
    }

    private static int[] filterIds(ISevenZipInArchive inArchive, String regex) throws SevenZipException {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        int numberOfItems = inArchive.getNumberOfItems();
        Pattern pattern = Pattern.compile(regex);
        for (int i = 0; i < numberOfItems; ++i) {
            String path = (String)inArchive.getProperty(i, PropID.PATH);
            String fileName = new File(path).getName();
            if (!pattern.matcher(fileName).matches()) continue;
            idList.add(i);
        }
        int[] result = new int[idList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)idList.get(i);
        }
        return result;
    }

    private static int[] filterDirs(ISevenZipInArchive inArchive, String dirPattern) throws SevenZipException {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        int numberOfItems = inArchive.getNumberOfItems();
        for (int i = 0; i < numberOfItems; ++i) {
            String path = (String)inArchive.getProperty(i, PropID.PATH);
            String filePath = new File(path).getParent();
            if (!dirPattern.equalsIgnoreCase(filePath)) continue;
            idList.add(i);
        }
        int[] result = new int[idList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)idList.get(i);
        }
        return result;
    }

    public static void main(String[] args) {
    }

    class ExtractCallback
    implements IArchiveExtractCallback {
        private ISevenZipInArchive inArchive;
        private int index;
        private OutputStream outputStream;
        private File file;
        private ExtractAskMode extractAskMode;
        private boolean isFolder;

        ExtractCallback(ISevenZipInArchive inArchive) {
            this.inArchive = inArchive;
        }

        @Override
        public void setTotal(long total) throws SevenZipException {
        }

        @Override
        public void setCompleted(long completeValue) throws SevenZipException {
        }

        @Override
        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.closeOutputStream();
            this.index = index;
            this.extractAskMode = extractAskMode;
            this.isFolder = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
            if (extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            String path = (String)this.inArchive.getProperty(index, PropID.PATH);
            this.file = new File(ExtractSevenZip.this.outputDirectoryFile, path);
            if (this.isFolder) {
                this.createDirectory(this.file);
                return null;
            }
            this.createDirectory(this.file.getParentFile());
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new SevenZipException("Error opening file: " + this.file.getAbsolutePath(), e);
            }
            if (ExtractSevenZip.this.logVerbose) {
                log.write(507, this.file.getAbsolutePath());
            }
            return new ISequentialOutStream(){

                @Override
                public int write(byte[] data) throws SevenZipException {
                    try {
                        ExtractCallback.this.outputStream.write(data);
                    }
                    catch (IOException e) {
                        throw new SevenZipException("Error writing to file: " + ExtractCallback.this.file.getAbsolutePath());
                    }
                    return data.length;
                }
            };
        }

        private void createDirectory(File parentFile) throws SevenZipException {
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new SevenZipException("Error creating directory: " + parentFile.getAbsolutePath());
            }
        }

        private void closeOutputStream() throws SevenZipException {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (IOException e) {
                    throw new SevenZipException("Error closing file: " + this.file.getAbsolutePath());
                }
            }
        }

        @Override
        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        @Override
        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            this.closeOutputStream();
            String path = (String)this.inArchive.getProperty(this.index, PropID.PATH);
            if (extractOperationResult != ExtractOperationResult.OK) {
                throw new SevenZipException("Invalid file: " + path);
            }
        }
    }

    class SevenOutStream
    implements ISequentialOutStream {
        FileOutputStream outStream = null;

        public SevenOutStream(File outFile) throws FileNotFoundException {
            this.outStream = new FileOutputStream(outFile);
        }

        public void close() throws IOException {
            this.outStream.close();
        }

        @Override
        public int write(byte[] data) {
            try {
                this.outStream.write(data);
            }
            catch (IOException ex) {
                Logger.getLogger(ExtractSevenZip.class.getName()).log(Level.SEVERE, null, ex);
            }
            return data.length;
        }
    }

    public static class ExtractionException
    extends Exception {
        private static final long serialVersionUID = -5108931481040742838L;

        public ExtractionException(String msg) {
            super(msg);
        }

        public ExtractionException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

