/*
 * Decompiled with CFR 0.152.
 */
package utils;

import bsh2java.log;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class BackDelete {
    final String DelDir = "deldir";
    final String comment;

    public BackDelete(String comment) {
        this.comment = comment;
    }

    public boolean delete(final File dirFile) {
        if (dirFile != null) {
            if (!dirFile.exists()) {
                return true;
            }
            log.write(9, "Asynchronously delete files %1", this.comment);
            String newName = "deldir" + new SimpleDateFormat(".HHmmss").format(new Date());
            File newFolder = new File(dirFile.getParentFile(), newName);
            try {
                FileUtils.moveDirectoryToDirectory(dirFile, newFolder, true);
            }
            catch (IOException ex) {
                log.write(-1, "Failed to move folder 1% to %2 with error message %3", dirFile.getAbsolutePath(), newFolder.getAbsolutePath(), ex.getLocalizedMessage());
                return false;
            }
            int counter = 0;
            while (dirFile.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BackDelete.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (++counter < 100) continue;
                log.write(-1, "Failed to move folder 1% to %2", dirFile.getAbsolutePath(), newFolder.getAbsolutePath());
                return false;
            }
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    File[] files2;
                    WildcardFileFilter fileFilter = new WildcardFileFilter("deldir.*");
                    for (File file : files2 = dirFile.getParentFile().listFiles(fileFilter)) {
                        FileUtils.forceDelete(file);
                    }
                }
                catch (IOException ex) {
                    log.write(-1, "Failed to delete folder. Error: %1", ex.getLocalizedMessage());
                    return;
                }
                log.write(10, "Asynchronously deleted files %1", BackDelete.this.comment);
            }
        };
        thread.start();
        return true;
    }
}

