/*
 * Decompiled with CFR 0.152.
 */
package ssdeep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import ssdeep.EditDistance;
import ssdeep.SpamSumSignature;

public class ssdeep {
    public final int SPAMSUM_LENGTH = 64;
    public final int FUZZY_MAX_RESULT = 116;
    public final int FALSE = 0;
    public final int TRUE = 1;
    public final int MIN_BLOCKSIZE = 3;
    public final int ROLLING_WINDOW = 7;
    public final int BUFFER_SIZE = 8192;
    public final int HASH_PRIME = 16777619;
    public final int HASH_INIT = 671226215;
    public final String b64String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static byte[] b64;
    private RollingState roll_state;

    public ssdeep() {
        b64 = SpamSumSignature.GetBytes("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    }

    public char[] snprintf(int size, String format, Object ... args) {
        StringWriter writer = new StringWriter(size);
        PrintWriter out = new PrintWriter(writer);
        out.printf(format, args);
        out.close();
        String temp = writer.toString();
        char[] result = new char[temp.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = temp.charAt(i);
        }
        return result;
    }

    private long roll_hash(int c) {
        this.roll_state.h2 = this.roll_state.h2 - this.roll_state.h1 & 0xFFFFFFFFL;
        this.roll_state.h2 = this.roll_state.h2 + ((long)(7 * c) & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.roll_state.h1 = this.roll_state.h1 + (long)c & 0xFFFFFFFFL;
        this.roll_state.h1 = this.roll_state.h1 - (long)this.roll_state.window[(int)(this.roll_state.n % 7L)] & 0xFFFFFFFFL;
        this.roll_state.window[(int)(this.roll_state.n % 7L)] = c;
        ++this.roll_state.n;
        this.roll_state.h3 = this.roll_state.h3 << 5 & 0xFFFFFFFFL;
        this.roll_state.h3 = (this.roll_state.h3 ^ (long)(c & 0xFF)) & 0xFFFFFFFFL;
        return this.roll_state.h1 + this.roll_state.h2 + this.roll_state.h3 & 0xFFFFFFFFL;
    }

    private long roll_reset() {
        this.roll_state = new RollingState();
        return 0L;
    }

    private long sum_hash(int c, long h) {
        h = h * 16777619L & 0xFFFFFFFFL;
        h = (h ^ (long)c) & 0xFFFFFFFFL;
        return h;
    }

    private void ss_init(ss_context ctx, File handle) {
        if (null == ctx) {
            throw new IllegalArgumentException("ctx");
        }
        if (handle != null) {
            ctx.total_chars = handle.length();
        }
        ctx.block_size = 3L;
        while (ctx.block_size * 64L < ctx.total_chars) {
            ctx.block_size *= 2L;
        }
    }

    private void ss_engine(ss_context ctx, byte[] buffer, int buffer_size) {
        if (null == ctx || null == buffer) {
            return;
        }
        for (int i = 0; i < buffer_size; ++i) {
            if (buffer[i] >= 0) {
                ctx.h = this.roll_hash(buffer[i]);
                ctx.h2 = this.sum_hash(buffer[i], ctx.h2);
                ctx.h3 = this.sum_hash(buffer[i], ctx.h3);
            } else {
                ctx.h = this.roll_hash(buffer[i] + 256);
                ctx.h2 = this.sum_hash(buffer[i] + 256, ctx.h2);
                ctx.h3 = this.sum_hash(buffer[i] + 256, ctx.h3);
            }
            if (ctx.h % ctx.block_size == ctx.block_size - 1L) {
                ctx.p[ctx.j] = b64[(int)(ctx.h2 % 64L)];
                if (ctx.j < 63) {
                    ctx.h2 = 671226215L;
                    ++ctx.j;
                }
            }
            if (ctx.h % (ctx.block_size * 2L) != ctx.block_size * 2L - 1L) continue;
            ctx.ret2[ctx.k] = b64[(int)(ctx.h3 % 64L)];
            if (ctx.k >= 31) continue;
            ctx.h3 = 671226215L;
            ++ctx.k;
        }
    }

    private int ss_update(ss_context ctx, RandomAccessFile stream) throws IOException {
        int bytes_read;
        if (null == ctx || null == stream) {
            return 1;
        }
        byte[] buffer = new byte[8192];
        ctx.p = new byte[65];
        ctx.ret2 = new byte[33];
        ctx.j = 0;
        ctx.k = 0;
        ctx.h2 = 671226215L;
        ctx.h3 = 671226215L;
        ctx.h = this.roll_reset();
        while ((bytes_read = stream.read(buffer, 0, buffer.length)) > 0) {
            this.ss_engine(ctx, buffer, bytes_read);
        }
        if (ctx.h != 0L) {
            ctx.p[ctx.j] = b64[(int)(ctx.h2 % 64L)];
            ctx.ret2[ctx.k] = b64[(int)(ctx.h3 % 64L)];
            ++ctx.j;
            ++ctx.k;
        }
        ctx.signature = new SpamSumSignature(ctx.block_size, this.GetArray(ctx.p, ctx.j), this.GetArray(ctx.ret2, ctx.k));
        return 0;
    }

    private byte[] GetArray(byte[] input, int maxLength) {
        if (input.length == maxLength) {
            return input;
        }
        byte[] output = new byte[maxLength];
        ssdeep.Copy(input, 0, output, 0, maxLength);
        return output;
    }

    private static int Copy(byte[] source, int sourceIdx, byte[] destination, int destinationIdx, int maxLength) {
        for (int idx = 0; idx < maxLength; ++idx) {
            if (sourceIdx + idx >= source.length) {
                return idx;
            }
            if (source[sourceIdx + idx] == 0) {
                return idx;
            }
            destination[destinationIdx + idx] = source[sourceIdx + idx];
        }
        return maxLength;
    }

    public String fuzzy_hash_file(File file) throws IOException {
        RandomAccessFile stream = new RandomAccessFile(file, "r");
        if (null == stream) {
            throw new IllegalArgumentException("stream");
        }
        boolean done = false;
        ss_context ctx = new ss_context();
        long filepos = stream.getFilePointer();
        this.ss_init(ctx, file);
        while (!done) {
            stream.seek(0L);
            this.ss_update(ctx, stream);
            if (ctx.block_size > 3L && ctx.j < 32) {
                ctx.block_size /= 2L;
                continue;
            }
            done = true;
        }
        stream.seek(filepos);
        return ctx.signature.toString();
    }

    public String fuzzy_hash_file(String file) throws FileNotFoundException, IOException {
        File f = new File(file);
        return this.fuzzy_hash_file(f);
    }

    private int has_common_substring(byte[] s1, byte[] s2) {
        int i;
        long[] hashes = new long[64];
        this.roll_reset();
        for (i = 0; i < s1.length; ++i) {
            hashes[i] = this.roll_hash(s1[i]);
        }
        int num_hashes = i;
        this.roll_reset();
        for (i = 0; i < s2.length; ++i) {
            long h = this.roll_hash(s2[i]);
            if (i < 6) continue;
            for (int j = 6; j < num_hashes; ++j) {
                if (hashes[j] == 0L || hashes[j] != h || s2.length - i - 6 < 7 || this.ArrayCompare(s2, s2.length - i - 6, s1, s1.length - j - 6, 7) != 0) continue;
                return 1;
            }
        }
        return 0;
    }

    private int ArrayCompare(byte[] array1, int idx1, byte[] array2, int idx2, int rollingWindow) {
        boolean result = true;
        for (int a = 0; a < rollingWindow; ++a) {
            if (a + idx1 > array1.length) {
                return 1;
            }
            if (a + idx2 > array2.length) {
                return 2;
            }
            if (result &= array1[a + idx1] == array2[a + idx2]) continue;
            return -1;
        }
        return 0;
    }

    private byte[] eliminate_sequences(byte[] str) {
        byte[] ret = (byte[])str.clone();
        int len = str.length;
        int j = 3;
        for (int i = 3; i < len; ++i) {
            if (str[i] == str[i - 1] && str[i] == str[i - 2] && str[i] == str[i - 3]) continue;
            ret[j++] = str[i];
        }
        ret[j] = 0;
        return ret;
    }

    private byte[] eliminate_sequences2(byte[] str) {
        int len = str.length;
        byte[] ret = new byte[len];
        int j = 3;
        for (int i = 3; i < len; ++i) {
            if (str[i] == str[i - 1] && str[i] == str[i - 2] && str[i] == str[i - 3]) continue;
            ret[j++] = str[i];
        }
        return ret;
    }

    private long score_strings(byte[] s1, byte[] s2, long block_size) {
        int len1 = s1.length;
        int len2 = s2.length;
        if (len1 > 64 || len2 > 64) {
            return 0L;
        }
        if (this.has_common_substring(s1, s2) == 0) {
            return 0L;
        }
        long score = this.edit_distn(s1, len1, s2, len2);
        score = score * 64L / (long)(len1 + len2);
        if ((score = 100L * score / 64L) >= 100L) {
            return 0L;
        }
        if ((score = 100L - score) > block_size / 3L * (long)Math.min(len1, len2)) {
            score = block_size / 3L * (long)Math.min(len1, len2);
        }
        return score;
    }

    private int edit_distn(byte[] s1, int len1, byte[] s2, int len2) {
        return EditDistance.edit_distn(s1, len1, s2, len2);
    }

    public int Compare(SpamSumSignature signature1, SpamSumSignature signature2) {
        long score;
        long block_size2;
        if (null == signature1 || null == signature2) {
            return -1;
        }
        long block_size1 = signature1.getBlockSize();
        if (block_size1 != (block_size2 = signature2.getBlockSize()) && block_size1 != block_size2 * 2L && block_size2 != block_size1 * 2L) {
            return 0;
        }
        byte[] s1 = this.eliminate_sequences2(signature1.getHashPart1());
        byte[] s2 = this.eliminate_sequences2(signature2.getHashPart1());
        byte[] s1_1 = s1;
        byte[] s2_1 = s2;
        byte[] s1_2 = this.eliminate_sequences2(signature1.getHashPart2());
        byte[] s2_2 = this.eliminate_sequences2(signature2.getHashPart2());
        if (block_size1 == block_size2) {
            long score1 = this.score_strings(s1_1, s2_1, block_size1);
            long score2 = this.score_strings(s1_2, s2_2, block_size2);
            score = Math.max(score1, score2);
        } else {
            score = block_size1 == block_size2 * 2L ? this.score_strings(s1_1, s2_2, block_size1) : this.score_strings(s1_2, s2_1, block_size2);
        }
        return (int)score;
    }

    private int MAX(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    private int MIN(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private class RollingState {
        public int[] window = new int[7];
        public long h1 = 0L;
        public long h2 = 0L;
        public long h3 = 0L;
        public long n = 0L;
    }

    private class ss_context {
        public byte[] p = null;
        public long total_chars = 0L;
        public long h = 0L;
        public long h2 = 0L;
        public long h3 = 0L;
        public int j = 0;
        public int n = 0;
        public int i = 0;
        public int k = 0;
        public long block_size = 0L;
        public byte[] ret2 = new byte[33];
        public SpamSumSignature signature;
    }
}

