/*
 * Decompiled with CFR 0.152.
 */
package ssdeep;

public class SpamSumSignature {
    private long blockSize;
    private byte[] hash1;
    private byte[] hash2;

    public static byte[] GetBytes(String str) {
        byte[] r = new byte[str.length()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)str.charAt(i);
        }
        return r;
    }

    public static String GetString(byte[] hsh) {
        String r = "";
        for (int i = 0; i < hsh.length; ++i) {
            r = r + (char)hsh[i];
        }
        return r;
    }

    public SpamSumSignature(String signature) {
        if (null == signature) {
            throw new IllegalArgumentException("Signature string cannot be null or empty.\r\nParameter name: signature");
        }
        int idx1 = signature.indexOf(58);
        int idx2 = signature.indexOf(58, idx1 + 1);
        if (idx1 < 0) {
            throw new IllegalArgumentException("Signature is not valid.\r\nParameter name: signature");
        }
        if (idx2 < 0) {
            throw new IllegalArgumentException("Signature is not valid.\r\nParameter name: signature");
        }
        this.blockSize = Integer.parseInt(signature.substring(0, 0 + idx1));
        this.hash1 = SpamSumSignature.GetBytes(signature.substring(idx1 + 1, idx1 + 1 + idx2 - idx1 - 1));
        this.hash2 = SpamSumSignature.GetBytes(signature.substring(idx2 + 1));
    }

    public SpamSumSignature(long blockSize, byte[] hash1, byte[] hash2) {
        this.blockSize = blockSize;
        this.hash1 = hash1;
        this.hash2 = hash2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpamSumSignature)) {
            return false;
        }
        return this.equals((SpamSumSignature)obj);
    }

    public boolean equals(SpamSumSignature other) {
        int idx;
        if (this.blockSize != other.blockSize) {
            return false;
        }
        if (this.hash1.length != other.hash1.length) {
            return false;
        }
        if (this.hash2.length != other.hash2.length) {
            return false;
        }
        for (idx = 0; idx < this.hash1.length; ++idx) {
            if (this.hash1[idx] == other.hash1[idx]) continue;
            return false;
        }
        for (idx = 0; idx < this.hash2.length; ++idx) {
            if (this.hash2[idx] == other.hash2[idx]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String hashText1 = SpamSumSignature.GetString(this.hash1);
        String hashText2 = SpamSumSignature.GetString(this.hash2);
        return this.blockSize + ":" + hashText1 + ":" + hashText2;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public byte[] getHashPart1() {
        return this.hash1;
    }

    public byte[] getHashPart2() {
        return this.hash2;
    }
}

