/*
 * Decompiled with CFR 0.152.
 */
package ssdeep;

public class EditDistance {
    private static final int MIN_DIST = 100;
    private static final int THRESHOLD = 4000;
    private static final int STRLENTHRESHOLD = 498;
    static int insert_cost = 1;
    static int delete_cost = 1;
    static int _iswap;
    static char _cswap;
    static int _mx;
    static int _my;
    static int _mz;
    static int row;
    static int col;
    static int index;
    static int radix;
    static int low;
    static int[] buffer;
    static int[] store;
    static int ins;
    static int del;
    static int ch;
    static int swap_cost;
    static int from_len;
    static int to_len;

    private static void swap_int(int[] x, int[] y) {
        int _iswap = x[0];
        x[0] = y[0];
        y[0] = _iswap;
    }

    private static void swap_char(byte[][] x, byte[][] y) {
        byte[] _cswap = x[0];
        x[0] = y[0];
        y[0] = _cswap;
    }

    private static int min3(int x, int y, int z) {
        int _mx = x;
        int _my = y;
        int _mz = z;
        return _mx < _my ? (_mx < _mz ? _mx : _mz) : (_mz < _my ? _mz : _my);
    }

    private static int min2(int x, int y) {
        int _mx = x;
        int _my = y;
        return _mx < _my ? _mx : _my;
    }

    private static int ar(int x, int y, int index) {
        return x == 0 ? y * del : (y == 0 ? x * ins : buffer[EditDistance.mod(index)]);
    }

    private static int NW(int x, int y) {
        return EditDistance.ar(x, y, index + from_len + 2);
    }

    private static int N(int x, int y) {
        return EditDistance.ar(x, y, index + from_len + 3);
    }

    private static int W(int x, int y) {
        return EditDistance.ar(x, y, index + radix - 1);
    }

    private static int NNWW(int x, int y) {
        return EditDistance.ar(x, y, index + 1);
    }

    private static int mod(int x) {
        return x % radix;
    }

    public static int edit_distn(byte[] from, int _from_len, byte[] to, int _to_len) {
        from_len = _from_len;
        to_len = _to_len;
        if (from == null) {
            if (to == null) {
                return 0;
            }
            return to_len * insert_cost;
        }
        if (to == null) {
            return from_len * delete_cost;
        }
        radix = 2 * from_len + 3;
        if (from_len > to_len && from_len > 498) {
            int[] x = new int[1];
            int[] y = new int[1];
            x[0] = from_len;
            y[0] = to_len;
            EditDistance.swap_int(x, y);
            byte[][] xx = new byte[1][];
            byte[][] yy = new byte[1][];
            xx[0] = from;
            yy[0] = to;
            EditDistance.swap_char(xx, yy);
        }
        buffer = from_len <= 498 ? store : new int[radix];
        EditDistance.buffer[EditDistance.index++] = EditDistance.min2(ins + del, from[0] == to[0] ? 0 : ch);
        low = buffer[EditDistance.mod(index + radix - 1)];
        for (col = 1; col < from_len; ++col) {
            EditDistance.buffer[EditDistance.index] = EditDistance.min3(col * del + (from[col] == to[0] ? 0 : ch), (col + 1) * del + ins, buffer[index - 1] + del);
            if (buffer[index] < low) {
                low = buffer[index];
            }
            ++index;
        }
        for (row = 1; row < to_len; ++row) {
            for (col = 0; col < from_len; ++col) {
                EditDistance.buffer[EditDistance.index] = EditDistance.min3(EditDistance.NW(row, col) + (from[col] == to[row] ? 0 : ch), EditDistance.N(row, col + 1) + ins, EditDistance.W(row + 1, col) + del);
                if (from[col] == to[row - 1] && col > 0 && from[col - 1] == to[row]) {
                    EditDistance.buffer[EditDistance.index] = EditDistance.min2(buffer[index], EditDistance.NNWW(row - 1, col - 1) + swap_cost);
                }
                if (buffer[index] < low || col == 0) {
                    low = buffer[index];
                }
                index = EditDistance.mod(index + 1);
            }
            if (low > 100) break;
        }
        row = buffer[EditDistance.mod(index + radix - 1)];
        return row;
    }

    static {
        index = 0;
        store = new int[1000];
        ins = 1;
        del = 1;
        ch = 3;
        swap_cost = 5;
    }
}

