/*
 * Decompiled with CFR 0.152.
 */
package sources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import logOld.MessageOld;
import sources.SourceDetails;
import sources.SourceIdentificator;

public class SourceList {
    ArrayList list = new ArrayList();
    SourceIdentificator sourceId = new SourceIdentificator();
    private SourceDetails defaultSource;

    public MessageOld add(String providedSource) {
        MessageOld message = new MessageOld();
        File folder = new File(providedSource);
        if (!folder.exists()) {
            message.set(-1, "Source '%1' does not exist", folder.getAbsolutePath());
            return message;
        }
        if (folder.isFile()) {
            message.set(-1, "Source '%1' is not a folder", folder.getAbsolutePath());
            return message;
        }
        SourceDetails source = this.sourceId.analyze(folder);
        if (!source.isValid.booleanValue()) {
            message.set(-1, "Source '%1' is not a valid Windows source", folder.getAbsolutePath());
            return message;
        }
        this.list.add(source);
        this.defaultSource = source;
        String versionId = source.versionText + ", " + "release " + source.versionMajor + "." + source.versionMinor + "." + source.versionBuild + "." + source.versionExtra;
        message.set(22, "Source '%1' was identified as %2", folder.getAbsolutePath(), versionId);
        try {
            this.saveSourceDetailsToDisk(source);
        }
        catch (JAXBException ex) {
            Logger.getLogger(SourceList.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SourceList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return message;
    }

    public ArrayList<SourceDetails> get() {
        return this.list;
    }

    public SourceDetails getDefaultSource() {
        return this.defaultSource;
    }

    public void saveSourceDetailsToDisk(Object object) throws JAXBException, FileNotFoundException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{SourceDetails.class});
        Marshaller marshallerObj = contextObj.createMarshaller();
        marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
        marshallerObj.marshal(object, (OutputStream)new FileOutputStream("outputSource.xml"));
    }
}

