/*
 * Decompiled with CFR 0.152.
 */
package sources;

import exeversion.image_win_executable;
import java.io.File;
import logOld.MessageOld;
import sources.SourceDetails;

public class SourceIdentificator {
    SourceDetails source = new SourceDetails();
    MessageOld msg = new MessageOld();

    Boolean detectNT6above(File rootFolder) {
        File file = new File(rootFolder, "setup.exe");
        if (!file.exists() || file.isDirectory()) {
            this.msg.set(404, "The setup.exe file was not found in %1", file.getAbsolutePath());
            this.source.isValid = false;
            this.source.invalidReason = this.msg.getMessage();
            return false;
        }
        image_win_executable win_exe = new image_win_executable();
        String targetEXE = file.getAbsolutePath();
        if (!win_exe.read(targetEXE).booleanValue()) {
            this.msg.set(-1, "Unable to read version from %1", targetEXE);
            this.source.isValid = false;
            this.source.invalidReason = this.msg.getMessage();
            return false;
        }
        this.source.architecture = win_exe.getArchitecture();
        this.source.language = win_exe.getLanguage();
        this.source.versionText = win_exe.getVersion();
        if (!this.decomposeData().booleanValue()) {
            this.msg.set(-1, "Unable to decompose the setup version from %1", targetEXE);
            this.source.isValid = false;
            this.source.invalidReason = this.msg.getMessage();
            return false;
        }
        this.source.isValid = true;
        return true;
    }

    SourceDetails analyze(File folder) {
        this.source.rootFolder = folder;
        if (!this.detectNT6above(folder).booleanValue()) {
            // empty if block
        }
        return this.source;
    }

    Boolean decomposeData() {
        try {
            String[] data = this.source.versionText.split("\\.");
            this.source.versionMajor = Integer.parseInt(data[0]);
            this.source.versionMinor = Integer.parseInt(data[1]);
            this.source.versionBuild = Integer.parseInt(data[2]);
            this.source.versionExtra = Integer.parseInt(data[3]);
            if (this.source.versionMajor == 6) {
                if (this.source.versionMinor == 2) {
                    this.source.versionText = "Windows 8";
                }
                if (this.source.versionMinor == 1) {
                    this.source.versionText = "Windows 7/Server 2008 R2";
                }
                if (this.source.versionMinor == 0) {
                    this.source.versionText = "Windows Vista/Server 2008";
                }
            }
            if (this.source.versionMajor == 5) {
                if (this.source.versionMinor == 2) {
                    this.source.versionText = "Windows XP 64bit / 2003-R2";
                }
                if (this.source.versionMinor == 1) {
                    this.source.versionText = "Windows XP";
                }
                if (this.source.versionMinor == 0) {
                    this.source.versionText = "Windows 2000";
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

