/*
 * Decompiled with CFR 0.152.
 */
package rewim.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import rewim.BadFormatException;
import rewim.compress.CopyDecoder;
import rewim.compress.CopyEncoder;
import rewim.compress.Decoder;
import rewim.compress.Encoder;
import rewim.compress.lzx.LZXDecoder;
import rewim.compress.xpress.XPressDecoder;
import rewim.compress.xpress.XPressEncoder;
import rewim.core.Chunk;
import rewim.core.CompressMode;
import rewim.core.FileResource;

public class DecodeUtil {
    public static void decode(ByteBuffer src, ByteBuffer dest, CompressMode mode) throws BadFormatException {
        Decoder decoder;
        CopyDecoder copyDecoder = new CopyDecoder();
        switch (mode) {
            case XPRESS: {
                decoder = new XPressDecoder();
                break;
            }
            case LZX: {
                decoder = new LZXDecoder();
                break;
            }
            case NONE: {
                decoder = new CopyDecoder();
                break;
            }
            default: {
                throw new BadFormatException("unknown compress type");
            }
        }
        src = src.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        dest = dest.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        FileResource fileResource = new FileResource(src, dest.remaining());
        int srcbase = fileResource.getBase();
        int destbase = dest.position();
        for (Chunk chunk : fileResource) {
            src.position(srcbase + chunk.getOffset());
            src.limit(srcbase + chunk.getEndPos());
            dest.position(destbase);
            dest.limit(destbase += chunk.getOrigSize());
            Decoder actualDecoder = chunk.getSize() == chunk.getOrigSize() ? copyDecoder : decoder;
            actualDecoder.setInput(src);
            actualDecoder.decode(dest);
        }
    }

    public static void encode(ByteBuffer src, ByteBuffer dest, CompressMode mode) throws BadFormatException {
        Encoder encoder;
        CopyEncoder copyEncoder = new CopyEncoder();
        switch (mode) {
            case NONE: {
                encoder = copyEncoder;
                break;
            }
            case XPRESS: {
                encoder = new XPressEncoder();
                break;
            }
            default: {
                throw new BadFormatException("unknown compress type");
            }
        }
        int sourceBase = src.position();
        int destStart = dest.position();
        int totalSize = src.remaining();
        int chunkNum = (totalSize + 32768 - 1) / 32768;
        int chunkEntries = chunkNum - 1;
        int destBase = destStart + chunkEntries * 4;
        dest.position(destBase);
        int[] chunkSize = new int[chunkEntries];
        for (int i = 0; i < chunkNum; ++i) {
            src.position(sourceBase + i * 32768);
            src.limit(Math.min(src.position() + 32768, sourceBase + totalSize));
            encoder.setInput(src);
            if (i > 0) {
                chunkSize[i - 1] = dest.position() - destBase;
            }
            encoder.encode(dest);
        }
        int limit = dest.position();
        dest.position(destStart);
        for (int size : chunkSize) {
            dest.putInt(size);
        }
        dest.position(limit);
    }
}

