/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rewim.ProgressMonitor;
import rewim.WimEditor;
import rewim.WimExtractor;
import rewim.WimParser;
import rewim.core.DirEntry;
import rewim.core.Image;
import rewim.gui.FileNameRenderer;
import rewim.gui.FileSizeRenderer;
import rewim.gui.FileTableModel;
import rewim.gui.FileTreeNode;
import rewim.gui.ProgressDialog;
import rewim.i18n.Messages;

public class reWIM
extends JFrame {
    private Image image;
    private DirEntry currentEntry;
    private ProgressMonitor monitor;
    private FileTableModel model = new FileTableModel();
    private WimEditor editor;
    private JButton btnAbout;
    private JButton btnAdd;
    private JButton btnCommit;
    private JButton btnDelete;
    private JButton btnExtract;
    private JButton btnInfo;
    private JButton btnOpen;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JTable table;
    private JTree tree;

    public reWIM() {
        URL imgURL = this.getClass().getResource("icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(imgURL));
        this.initComponents();
        this.monitor = ProgressDialog.createProgressDialog(this);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new FileNameRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new FileSizeRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = reWIM.this.table.getSelectedRow();
                if (index == -1) {
                    return;
                }
                reWIM.this.setCurrentEntry((DirEntry)reWIM.this.table.getValueAt(index, 0));
            }
        });
        this.table.setShowGrid(false);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.btnOpen = new JButton();
        this.btnExtract = new JButton();
        this.btnAdd = new JButton();
        this.btnDelete = new JButton();
        this.btnCommit = new JButton();
        this.btnInfo = new JButton();
        this.btnAbout = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.setDefaultCloseOperation(3);
        this.setTitle("reWIM");
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(607, 297));
        this.jToolBar1.setRollover(true);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/icons/database_connect.png")));
        this.btnOpen.setText("Open");
        this.btnOpen.setFocusable(false);
        this.btnOpen.setHorizontalTextPosition(0);
        this.btnOpen.setVerticalTextPosition(3);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnOpenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnOpen);
        this.btnExtract.setIcon(new ImageIcon(this.getClass().getResource("/icons/document_export.png")));
        this.btnExtract.setText("Export");
        this.btnExtract.setEnabled(false);
        this.btnExtract.setFocusable(false);
        this.btnExtract.setHorizontalTextPosition(0);
        this.btnExtract.setVerticalTextPosition(3);
        this.btnExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnExtractActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExtract);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/icons/document_import.png")));
        this.btnAdd.setText("Import");
        this.btnAdd.setEnabled(false);
        this.btnAdd.setFocusable(false);
        this.btnAdd.setHorizontalTextPosition(0);
        this.btnAdd.setVerticalTextPosition(3);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAdd);
        this.btnAdd.getAccessibleContext().setAccessibleName("btnAdd");
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/icons/page_delete.png")));
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.setFocusable(false);
        this.btnDelete.setHorizontalTextPosition(0);
        this.btnDelete.setVerticalTextPosition(3);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDelete);
        this.btnDelete.getAccessibleContext().setAccessibleName("btnDelete");
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/icons/database_save.png")));
        this.btnCommit.setText("Commit");
        this.btnCommit.setEnabled(false);
        this.btnCommit.setFocusable(false);
        this.btnCommit.setHorizontalTextPosition(0);
        this.btnCommit.setVerticalTextPosition(3);
        this.btnCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnCommitActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCommit);
        this.btnInfo.setIcon(new ImageIcon(this.getClass().getResource("/icons/document_info.png")));
        this.btnInfo.setText("Info");
        this.btnInfo.setEnabled(false);
        this.btnInfo.setFocusable(false);
        this.btnInfo.setHorizontalTextPosition(0);
        this.btnInfo.setVerticalTextPosition(3);
        this.btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnInfoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnInfo);
        this.btnAbout.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.png")));
        this.btnAbout.setText("About");
        this.btnAbout.setFocusable(false);
        this.btnAbout.setHorizontalTextPosition(0);
        this.btnAbout.setVerticalTextPosition(3);
        this.btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                reWIM.this.btnAboutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAbout);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                reWIM.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.table.setModel(this.model);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addComponent(this.jToolBar1, -1, 607, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 233, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE))));
        this.pack();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.openFile();
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        FileTreeNode fileNode;
        DirEntry entry;
        Object node = this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof FileTreeNode && (entry = (fileNode = (FileTreeNode)node).getEntry()) != null) {
            this.model.setEntry(entry);
            this.setCurrentEntry(entry);
        }
    }

    private void btnExtractActionPerformed(ActionEvent evt) {
        this.extractFile();
    }

    private void btnInfoActionPerformed(ActionEvent evt) {
        this.showInfo();
    }

    private void btnAboutActionPerformed(ActionEvent evt) {
        this.showAbout();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.addFile();
    }

    private void btnCommitActionPerformed(ActionEvent evt) {
        this.commit();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.removeFile();
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(reWIM.class);
        String lastUsedDir = prefs.get("LastUsedDir", "");
        File lastFolder = new File(lastUsedDir);
        if (lastFolder.exists()) {
            fc.setCurrentDirectory(new File(lastUsedDir));
        }
        fc.setDialogTitle(Messages.getString("gui.fileopen.title"));
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("gui.file.description");
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".wim");
            }
        });
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (file.exists()) {
            prefs.put("LastUsedDir", file.getParent());
            new OpenFileThread(file).start();
        }
    }

    private void setCurrentEntry(DirEntry entry) {
        this.currentEntry = entry;
        String path = entry.getFullPath();
        this.btnExtract.setEnabled(true);
        this.btnAdd.setEnabled(this.currentEntry.isDir());
        this.btnDelete.setEnabled(this.currentEntry.getParent() != null);
    }

    private void extractFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Messages.getString("gui.filechooser.title"));
        fc.setFileSelectionMode(1);
        if (fc.showSaveDialog(this) == 0) {
            new ExtractFileThread(fc.getSelectedFile()).start();
        }
    }

    private void showInfo() {
        if (this.image != null) {
            String infoContent = "Boot Index: " + this.image.getHeader().getBootIndex() + "\n" + this.image.getPrettyXml();
            JTextArea textArea = new JTextArea(infoContent);
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(350, 450));
            JOptionPane.showMessageDialog(this, scrollPane, Messages.getString("gui.info.title"), -1);
        }
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this, Messages.getString("msg.license"), Messages.getString("gui.about.title"), 1);
    }

    private static void showError(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        JTextArea textArea = new JTextArea();
        textArea.setText(writer.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(300, 150));
        JOptionPane.showMessageDialog(null, scrollPane, Messages.getString("gui.error.title"), 0);
    }

    private void addFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        if (fc.showOpenDialog(this) == 0) {
            File target = fc.getSelectedFile();
            try {
                this.editor.add(target, this.currentEntry);
                this.btnCommit.setEnabled(true);
            }
            catch (Exception ex) {
                Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
                reWIM.showError(ex);
            }
        }
    }

    private void removeFile() {
        try {
            this.editor.remove(this.currentEntry);
        }
        catch (Exception ex) {
            Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
            reWIM.showError(ex);
        }
    }

    private void commit() {
        JOptionPane.showMessageDialog(this, this.editor.preview());
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose where to save the updated WIM");
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("gui.file.description");
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".wim");
            }
        });
        if (fc.showSaveDialog(this) == 0) {
            try {
                this.editor.commit(fc.getSelectedFile());
            }
            catch (Exception ex) {
                Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
                reWIM.showError(ex);
            }
        }
    }

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(reWIM.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new reWIM().setVisible(true);
            }
        });
    }

    private class ExtractFileThread
    extends Thread {
        private final File file;

        public ExtractFileThread(File file) {
            super("Extract File Thread");
            this.file = file;
        }

        @Override
        public void run() {
            try {
                WimExtractor extractor = new WimExtractor(reWIM.this.image);
                extractor.setMonitor(reWIM.this.monitor);
                extractor.setSource(reWIM.this.currentEntry);
                extractor.setDest(this.file);
                extractor.extract();
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        reWIM.showError(e);
                    }
                });
            }
        }
    }

    private class OpenFileThread
    extends Thread {
        private final File file;

        public OpenFileThread(File file) {
            super("Open File Thread");
            this.file = file;
        }

        @Override
        public void run() {
            try {
                WimParser parser = new WimParser(this.file.getAbsolutePath());
                parser.setMonitor(reWIM.this.monitor);
                reWIM.this.image = parser.parse();
                reWIM.this.editor = new WimEditor(reWIM.this.image);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        reWIM.this.tree.setModel(new DefaultTreeModel(new FileTreeNode(reWIM.this.image), true));
                        reWIM.this.btnInfo.setEnabled(true);
                    }
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        reWIM.showError(e);
                    }
                });
            }
        }
    }
}

