/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import rewim.ProgressMonitor;
import rewim.WimExtractor;
import rewim.WimParser;
import rewim.core.DirEntry;
import rewim.core.Image;
import rewim.gui.FileNameRenderer;
import rewim.gui.FileSizeRenderer;
import rewim.gui.FileTableModel;
import rewim.gui.FileTreeNode;
import rewim.gui.ProgressDialog;
import rewim.i18n.Messages;

public class WimExplorer
implements TreeSelectionListener,
ListSelectionListener {
    private JFrame frame;
    private JTextField textAddr;
    private JTable table;
    private Image image;
    private FileTableModel model;
    private JTree tree;
    private JLabel lblStatus;
    private JButton btnCommit;
    private JButton btnInfo;
    private JButton btnOpen;
    ProgressMonitor monitor;
    private JButton btnAbout;
    private JSeparator separator;
    private DirEntry currentEntry;
    private JButton btnExtract;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            Logger.getLogger(WimExplorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WimExplorer window = new WimExplorer();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    WimExplorer.showError(e);
                }
            }
        });
    }

    public WimExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setTitle(Messages.getString("gui.title"));
        this.frame.setBounds(100, 100, 450, 300);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocationRelativeTo(null);
        JToolBar toolBar = new JToolBar();
        this.frame.getContentPane().add((Component)toolBar, "North");
        this.btnOpen = new JButton();
        this.btnOpen.setToolTipText(Messages.getString("gui.button.open"));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WimExplorer.this.openFile();
            }
        });
        this.btnOpen.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/open.png")));
        toolBar.add(this.btnOpen);
        this.btnExtract = new JButton();
        this.btnExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WimExplorer.this.extractFile();
            }
        });
        this.btnExtract.setEnabled(false);
        this.btnExtract.setToolTipText(Messages.getString("gui.button.extract"));
        this.btnExtract.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/extract.png")));
        toolBar.add(this.btnExtract);
        this.btnCommit = new JButton();
        this.btnCommit.setToolTipText(Messages.getString("gui.button.commit"));
        this.btnCommit.setEnabled(false);
        this.btnCommit.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/commit.png")));
        toolBar.add(this.btnCommit);
        this.btnInfo = new JButton();
        this.btnInfo.setToolTipText(Messages.getString("gui.button.info"));
        this.btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WimExplorer.this.showInfo();
            }
        });
        this.btnInfo.setEnabled(false);
        this.btnInfo.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/info.png")));
        toolBar.add(this.btnInfo);
        this.separator = new JSeparator();
        toolBar.add(this.separator);
        this.btnAbout = new JButton();
        this.btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WimExplorer.this.showAbout();
            }
        });
        this.btnAbout.setToolTipText(Messages.getString("gui.button.about"));
        this.btnAbout.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/about.png")));
        toolBar.add(this.btnAbout);
        JPanel panel = new JPanel();
        this.frame.getContentPane().add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panelStatus = new JPanel();
        panel.add((Component)panelStatus, "South");
        panelStatus.setLayout(new FlowLayout(0, 5, 5));
        this.lblStatus = new JLabel();
        panelStatus.add(this.lblStatus);
        JToolBar toolBarAddr = new JToolBar();
        panel.add((Component)toolBarAddr, "North");
        toolBarAddr.add(new JLabel(Messages.getString("gui.label.address")));
        this.textAddr = new JTextField();
        toolBarAddr.add(this.textAddr);
        this.textAddr.setColumns(10);
        JButton btnGo = new JButton(Messages.getString("gui.button.go"));
        btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WimExplorer.this.go(WimExplorer.this.textAddr.getText());
            }
        });
        btnGo.setIcon(new ImageIcon(WimExplorer.class.getResource("/icons/go.png")));
        toolBarAddr.add(btnGo);
        JSplitPane splitPane = new JSplitPane();
        panel.add((Component)splitPane, "Center");
        JScrollPane scrollPaneLeft = new JScrollPane();
        scrollPaneLeft.setMinimumSize(new Dimension(200, 200));
        splitPane.setLeftComponent(scrollPaneLeft);
        this.tree = new JTree();
        this.tree.setModel(null);
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        scrollPaneLeft.setViewportView(this.tree);
        JScrollPane scrollPaneRight = new JScrollPane();
        splitPane.setRightComponent(scrollPaneRight);
        this.model = new FileTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new FileNameRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new FileSizeRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setFillsViewportHeight(true);
        scrollPaneRight.setViewportView(this.table);
        this.monitor = ProgressDialog.createProgressDialog(this.frame);
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Messages.getString("gui.fileopen.title"));
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("gui.file.description");
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".wim");
            }
        });
        if (fc.showOpenDialog(this.frame) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (file.exists()) {
            new OpenFileThread(file).start();
        }
    }

    private void extractFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Messages.getString("gui.filechooser.title"));
        fc.setFileSelectionMode(1);
        if (fc.showSaveDialog(this.frame) == 0) {
            new ExtractFileThread(fc.getSelectedFile()).start();
        }
    }

    private void showInfo() {
        if (this.image != null) {
            JTextArea textArea = new JTextArea(this.image.getPrettyXml());
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(350, 450));
            JOptionPane.showMessageDialog(this.frame, scrollPane, Messages.getString("gui.info.title"), -1);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        FileTreeNode fileNode;
        DirEntry entry;
        Object node = this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof FileTreeNode && (entry = (fileNode = (FileTreeNode)node).getEntry()) != null) {
            this.model.setEntry(entry);
            this.setCurrentEntry(entry);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.setCurrentEntry((DirEntry)this.table.getValueAt(index, 0));
    }

    private void go(String path) {
    }

    private void setCurrentEntry(DirEntry entry) {
        this.currentEntry = entry;
        String path = entry.getFullPath();
        this.lblStatus.setText(path);
        this.textAddr.setText(path);
        this.btnExtract.setEnabled(true);
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this.frame, Messages.getString("msg.license"), Messages.getString("gui.about.title"), 1);
    }

    private static void showError(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        JTextArea textArea = new JTextArea();
        textArea.setText(writer.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(300, 150));
        JOptionPane.showMessageDialog(null, scrollPane, Messages.getString("gui.error.title"), 0);
    }

    private class ExtractFileThread
    extends Thread {
        private final File file;

        public ExtractFileThread(File file) {
            super("Extract File Thread");
            this.file = file;
        }

        @Override
        public void run() {
            try {
                WimExtractor extractor = new WimExtractor(WimExplorer.this.image);
                extractor.setMonitor(WimExplorer.this.monitor);
                extractor.setSource(WimExplorer.this.currentEntry);
                extractor.setDest(this.file);
                extractor.extract();
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WimExplorer.showError(e);
                    }
                });
            }
        }
    }

    private class OpenFileThread
    extends Thread {
        private final File file;

        public OpenFileThread(File file) {
            super("Open File Thread");
            this.file = file;
        }

        @Override
        public void run() {
            try {
                WimParser parser = new WimParser(this.file.getAbsolutePath());
                parser.setMonitor(WimExplorer.this.monitor);
                WimExplorer.this.image = parser.parse();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WimExplorer.this.tree.setModel(new DefaultTreeModel(new FileTreeNode(WimExplorer.this.image), true));
                        WimExplorer.this.btnInfo.setEnabled(true);
                    }
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WimExplorer.showError(e);
                    }
                });
            }
        }
    }
}

