/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import rewim.ProgressMonitor;

public class ProgressDialog
extends JDialog
implements ProgressMonitor {
    private JLabel lblMessage;
    private JProgressBar progressBar;
    private JList list;
    private long start;

    public static ProgressMonitor createProgressDialog(JFrame frame) {
        final ProgressDialog dialog = new ProgressDialog(frame);
        ProgressMonitor proxy = (ProgressMonitor)Proxy.newProxyInstance(dialog.getClass().getClassLoader(), new Class[]{ProgressMonitor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            method.invoke((Object)dialog, args);
                        }
                        catch (Exception e) {
                            Logger.getLogger(ProgressMonitor.class.getName()).log(Level.SEVERE, "invoke fail", e);
                        }
                    }
                });
                return null;
            }
        });
        return proxy;
    }

    private ProgressDialog(JFrame frame) {
        super((Frame)frame, false);
        this.setSize(400, 69);
        this.setLocationRelativeTo(frame);
        this.setLayout(new BorderLayout(0, 0));
        this.lblMessage = new JLabel("New label");
        this.getContentPane().add((Component)this.lblMessage, "North");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        panel.add((Component)this.progressBar, "North");
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "Center");
        this.list = new JList(new DefaultListModel());
        scrollPane.setViewportView(this.list);
    }

    @Override
    public void init() {
        this.lblMessage.setText("");
        this.progressBar.setValue(0);
        ((DefaultListModel)this.list.getModel()).removeAllElements();
        this.setVisible(true);
        this.start = System.currentTimeMillis();
    }

    @Override
    public void newProgress(String name) {
        this.updateMessage(name + "...");
    }

    @Override
    public void finishProgress() {
    }

    @Override
    public void appendMessage(String message) {
        ((DefaultListModel)this.list.getModel()).addElement(message);
    }

    @Override
    public void updateMessage(String message) {
        this.lblMessage.setText(message);
    }

    @Override
    public void setCurrentMessage(String message) {
        this.lblMessage.setText(message);
    }

    @Override
    public void setValue(int value) {
        this.progressBar.setValue(value);
    }

    @Override
    public void done() {
        long diff = System.currentTimeMillis() - this.start;
        StringBuilder sb = new StringBuilder();
        sb.append("\nTotal Time: ");
        long minutes = diff / 60L / 1000L;
        if (minutes > 0L) {
            sb.append(minutes);
            sb.append(" minute");
            if (minutes > 1L) {
                sb.append("s");
            }
        }
        long seconds = (diff - minutes * 60L * 1000L) / 1000L;
        sb.append(" ");
        sb.append(seconds);
        sb.append(" second");
        if (seconds > 1L) {
            sb.append("s");
        }
        this.setVisible(false);
    }
}

