/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import rewim.core.DirEntry;
import rewim.core.Image;

public class FileTreeNode
implements TreeNode {
    private DirEntry entry;
    private FileTreeNode parent;
    private List<FileTreeNode> children;

    public FileTreeNode(Image image) {
        this.children = new ArrayList<FileTreeNode>(image.getDirRoots().size());
        for (DirEntry child : image.getDirRoots()) {
            this.children.add(new FileTreeNode(child, this));
        }
    }

    public FileTreeNode(DirEntry entry, FileTreeNode parent) {
        this.entry = entry;
        this.parent = parent;
        this.children = new ArrayList<FileTreeNode>(entry.getChildren().size());
        for (DirEntry child : entry.getChildren()) {
            if (!child.isDir()) continue;
            this.children.add(new FileTreeNode(child, this));
        }
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public DirEntry getEntry() {
        return this.entry;
    }

    public String toString() {
        return this.entry != null ? this.entry.getFileName() : "/";
    }
}

