/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import javax.swing.table.AbstractTableModel;
import rewim.core.DirEntry;
import rewim.core.ResourceHeader;

public class FileTableModel
extends AbstractTableModel {
    private DirEntry entry;

    public void setEntry(DirEntry entry) {
        this.entry = entry;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.entry == null) {
            return 0;
        }
        return this.entry.getChildren().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.entry == null) {
            return 0;
        }
        DirEntry child = this.entry.getChildren().get(rowIndex);
        if (child == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return child;
            }
            case 1: {
                ResourceHeader header = child.getHeader();
                return header == null ? null : Long.valueOf(header.getHeaderShort().getOrigSize());
            }
            case 2: {
                return child.getLastAccessTime();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Last Modified";
            }
        }
        return null;
    }
}

