/*
 * Decompiled with CFR 0.152.
 */
package rewim.gui;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class FileIconManager {
    private static Map<String, Icon> iconCache = new HashMap<String, Icon>();
    private static Icon folderIcon;
    private static Icon blankIcon;

    public static Icon getFolderIcon() {
        if (folderIcon == null) {
            folderIcon = FileSystemView.getFileSystemView().getSystemIcon(new File("."));
        }
        return folderIcon;
    }

    public static Icon getBlankIcon() {
        if (blankIcon == null) {
            try {
                File tmp = File.createTempFile("icon", "");
                blankIcon = FileSystemView.getFileSystemView().getSystemIcon(tmp);
                tmp.delete();
            }
            catch (IOException e) {
                return null;
            }
        }
        return blankIcon;
    }

    public static Icon getIcon(String fileName) {
        if (fileName == null) {
            return FileIconManager.getBlankIcon();
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return FileIconManager.getBlankIcon();
        }
        String ext = fileName.substring(index);
        Icon icon = iconCache.get(ext);
        if (icon != null) {
            return icon;
        }
        try {
            File tmp = File.createTempFile("icon", "." + ext);
            icon = FileSystemView.getFileSystemView().getSystemIcon(tmp);
            iconCache.put(ext, icon);
            tmp.delete();
            return icon;
        }
        catch (IOException e) {
            return null;
        }
    }
}

