/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.nio.ByteBuffer;
import rewim.BadFormatException;
import rewim.WimElement;

public class SecurityBlock
implements WimElement {
    private int totalLength;
    private int entryNum;
    private long entryLength;
    private byte[] origBytes;

    @Override
    public void read(ByteBuffer buffer) throws BadFormatException {
        this.totalLength = buffer.getInt();
        this.origBytes = new byte[this.totalLength - 4];
        buffer.get(this.origBytes);
        buffer.position(this.totalLength);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putInt(this.totalLength);
        buffer.put(this.origBytes);
    }

    @Override
    public void init() {
        this.totalLength = 8;
        this.origBytes = new byte[4];
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public int getEntryNum() {
        return this.entryNum;
    }

    public void setEntryNum(int entryNum) {
        this.entryNum = entryNum;
    }

    public long getEntryLength() {
        return this.entryLength;
    }

    public void setEntryLength(long entryLength) {
        this.entryLength = entryLength;
    }
}

