/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import rewim.BadFormatException;
import rewim.WimElement;

public class ResourceHeaderShort
implements WimElement {
    public static final int LENGTH = 24;
    public static final byte FLAG_FREE = 1;
    public static final byte FLAG_METADATA = 2;
    public static final byte FLAG_COMPRESSED = 4;
    public static final byte FLAG_SPANNED = 8;
    private byte flag;
    private long size;
    private long offset;
    private long origSize;

    @Override
    public void read(ByteBuffer buffer) throws BadFormatException {
        long temp = buffer.getLong();
        this.flag = (byte)(temp >> 56);
        this.size = temp & 0xFFFFFFFL;
        this.offset = buffer.getLong();
        this.origSize = buffer.getLong();
    }

    @Override
    public void write(ByteBuffer buffer) {
        long temp = this.size | (long)this.flag << 56;
        buffer.putLong(temp);
        buffer.putLong(this.offset);
        buffer.putLong(this.origSize);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(24).order(ByteOrder.LITTLE_ENDIAN);
        this.write(buffer);
        byte[] result = new byte[24];
        buffer.flip();
        int index = 0;
        while (buffer.hasRemaining()) {
            result[index++] = buffer.get();
        }
        return result;
    }

    @Override
    public void init() {
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOrigSize() {
        return this.origSize;
    }

    public void setOrigSize(long origSize) {
        this.origSize = origSize;
    }

    public boolean isMetadata() {
        return (this.flag & 2) != 0;
    }

    public boolean isCompressed() {
        return (this.flag & 4) != 0;
    }

    public void setCompressed(boolean comp) {
        this.flag = comp ? (byte)(this.flag | 4) : (byte)(this.flag & 0xFFFFFFFB);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceHeaderShort [flag=").append(this.flag).append(", size=").append(this.size).append(", offset=").append(this.offset).append(", origSize=").append(this.origSize).append("]");
        return builder.toString();
    }
}

