/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import rewim.BadFormatException;
import rewim.WimElement;
import rewim.core.ResourceHeaderShort;

public class ResourceHeader
implements WimElement {
    public static final int LENGTH = 50;
    private ResourceHeaderShort headerShort;
    private short partNumber;
    private int refCount;
    private byte[] hash;
    private int hashcode;

    @Override
    public void read(ByteBuffer buffer) throws BadFormatException {
        this.headerShort = new ResourceHeaderShort();
        this.headerShort.read(buffer);
        this.partNumber = buffer.getShort();
        this.refCount = buffer.getInt();
        this.hash = new byte[20];
        buffer.get(this.hash);
        this.hashcode = Arrays.hashCode(this.hash);
    }

    @Override
    public void write(ByteBuffer buffer) {
        this.headerShort.write(buffer);
        buffer.putShort(this.partNumber);
        buffer.putInt(this.refCount);
        buffer.put(this.hash);
    }

    @Override
    public void init() {
        this.partNumber = 1;
        this.refCount = 1;
    }

    public ResourceHeaderShort getHeaderShort() {
        return this.headerShort;
    }

    public void setHeaderShort(ResourceHeaderShort headerShort) {
        this.headerShort = headerShort;
    }

    public short getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(short partNumber) {
        this.partNumber = partNumber;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
        this.hashcode = Arrays.hashCode(hash);
    }

    public void incrRefCount() {
        ++this.refCount;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceHeader other = (ResourceHeader)obj;
        if (!(this.headerShort == other.headerShort || this.headerShort != null && this.headerShort.equals(other.headerShort))) {
            return false;
        }
        if (this.partNumber != other.partNumber) {
            return false;
        }
        if (this.refCount != other.refCount) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        return this.hashcode == other.hashcode;
    }
}

