/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import rewim.core.DirEntry;
import rewim.core.Header;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.core.SecurityBlock;
import rewim.core.xml.Wim;

public class Image {
    private File source;
    private Header header;
    private Map<Integer, ResourceHeader> lookupTable = new HashMap<Integer, ResourceHeader>();
    private List<ResourceHeaderShort> imageRoots = new LinkedList<ResourceHeaderShort>();
    private List<SecurityBlock> securityBlocks = new LinkedList<SecurityBlock>();
    private List<DirEntry> dirRoots = new LinkedList<DirEntry>();
    private String origXml;
    private String prettyXml;
    private Wim xml;

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Map<Integer, ResourceHeader> getLookupTable() {
        return this.lookupTable;
    }

    public List<ResourceHeaderShort> getImageRoots() {
        return this.imageRoots;
    }

    public List<SecurityBlock> getSecurityBlocks() {
        return this.securityBlocks;
    }

    public List<DirEntry> getDirRoots() {
        return this.dirRoots;
    }

    public DirEntry findEntry(int index, String path) {
        DirEntry entry = this.dirRoots.get(index - 1);
        if ("".equals(path)) {
            return entry;
        }
        String[] segment = path.split("[\\\\/]");
        for (int i = 0; i < segment.length; ++i) {
            DirEntry child2;
            block5: {
                Boolean isRegex = segment[i].contains("*");
                for (DirEntry child2 : entry.getChildren()) {
                    Boolean isMatch;
                    if (isRegex.booleanValue()) {
                        String tst = segment[i].toLowerCase().replace(".", "\\.");
                        tst = tst.replace("*", ".*");
                        isMatch = child2.getFileName().toLowerCase().matches(tst);
                    } else {
                        isMatch = segment[i].equalsIgnoreCase(child2.getFileName());
                    }
                    if (!isMatch.booleanValue()) continue;
                    break block5;
                }
                return null;
            }
            entry = child2;
        }
        return entry;
    }

    private void transformXml() throws Exception {
        StringWriter output = new StringWriter();
        StreamSource source = new StreamSource(new StringReader(this.origXml));
        StreamResult result = new StreamResult(output);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
        this.prettyXml = output.toString();
    }

    public String getOrigXml() {
        return this.origXml;
    }

    public void setOrigXml(String xmlContent) {
        this.origXml = xmlContent;
        try {
            this.transformXml();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPrettyXml() {
        return this.prettyXml;
    }

    public Wim getXml() {
        return this.xml;
    }

    public void setXml(Wim xml) {
        this.xml = xml;
    }
}

