/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import rewim.BadFormatException;
import rewim.WimElement;
import rewim.core.CompressMode;
import rewim.core.ResourceHeaderShort;

public class Header
implements WimElement {
    private byte[] tag;
    private int size;
    private int version;
    private int flags;
    private int compressionSize;
    private UUID guid;
    private short partNumber;
    private short totalParts;
    private int imageCount;
    private ResourceHeaderShort offsetTable;
    private ResourceHeaderShort xmlData;
    private ResourceHeaderShort bootMetadata;
    private short bootIndex;
    private ResourceHeaderShort integrity;
    private static final int FLAG_COMPRESSED = 2;
    private static final int FLAG_XPRESS = 131072;
    private static final int FLAG_LZX = 262144;
    private static final byte[] TAG_WIM = new byte[]{77, 83, 87, 73, 77, 0, 0, 0};
    private static final int LATEST_VERSION = 68864;
    public static final int HEADER_SIZE = 208;

    @Override
    public void read(ByteBuffer buffer) throws BadFormatException {
        this.tag = new byte[8];
        buffer.get(this.tag);
        if (!Arrays.equals(this.tag, TAG_WIM)) {
            throw new BadFormatException("This is not a valid WIM archive");
        }
        this.size = buffer.getInt();
        this.version = buffer.getInt();
        this.flags = buffer.getInt();
        this.compressionSize = buffer.getInt();
        long lo = buffer.getLong();
        long hi = buffer.getLong();
        this.guid = new UUID(hi, lo);
        this.partNumber = buffer.getShort();
        this.totalParts = buffer.getShort();
        this.imageCount = buffer.getInt();
        this.offsetTable = this.readResourceHeader(buffer);
        this.xmlData = this.readResourceHeader(buffer);
        this.bootMetadata = this.readResourceHeader(buffer);
        this.bootIndex = buffer.getShort();
        this.integrity = this.readResourceHeader(buffer);
    }

    private ResourceHeaderShort readResourceHeader(ByteBuffer buffer) throws BadFormatException {
        ResourceHeaderShort res = new ResourceHeaderShort();
        res.read(buffer);
        return res;
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.put(TAG_WIM);
        buffer.putInt(this.size);
        buffer.putInt(this.version);
        buffer.putInt(this.flags);
        buffer.putInt(this.compressionSize);
        buffer.putLong(this.guid.getLeastSignificantBits());
        buffer.putLong(this.guid.getMostSignificantBits());
        buffer.putShort(this.partNumber);
        buffer.putShort(this.totalParts);
        buffer.putInt(this.imageCount);
        this.offsetTable.write(buffer);
        this.xmlData.write(buffer);
        this.bootMetadata.write(buffer);
        buffer.putShort(this.bootIndex);
        this.integrity.write(buffer);
    }

    @Override
    public void init() {
        this.size = 208;
        this.version = 68864;
        this.flags = 128;
        this.guid = UUID.randomUUID();
        this.partNumber = 1;
        this.totalParts = 1;
        this.imageCount = 1;
        this.bootMetadata = new ResourceHeaderShort();
        this.integrity = new ResourceHeaderShort();
    }

    public byte[] getTag() {
        return this.tag;
    }

    public void setTag(byte[] tag) {
        this.tag = tag;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getCompressionSize() {
        return this.compressionSize;
    }

    public void setCompressionSize(int compressionSize) {
        this.compressionSize = compressionSize;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public short getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(short partNumber) {
        this.partNumber = partNumber;
    }

    public short getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(short totalParts) {
        this.totalParts = totalParts;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int imageCount) {
        this.imageCount = imageCount;
    }

    public ResourceHeaderShort getOffsetTable() {
        return this.offsetTable;
    }

    public void setOffsetTable(ResourceHeaderShort offsetTable) {
        this.offsetTable = offsetTable;
    }

    public ResourceHeaderShort getXmlData() {
        return this.xmlData;
    }

    public void setXmlData(ResourceHeaderShort xmlData) {
        this.xmlData = xmlData;
    }

    public ResourceHeaderShort getBootMetadata() {
        return this.bootMetadata;
    }

    public void setBootMetadata(ResourceHeaderShort bootMetadata) {
        this.bootMetadata = bootMetadata;
    }

    public short getBootIndex() {
        return this.bootIndex;
    }

    public void setBootIndex(short bootIndex) {
        this.bootIndex = bootIndex;
    }

    public ResourceHeaderShort getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(ResourceHeaderShort integrity) {
        this.integrity = integrity;
    }

    public boolean isCompressed() {
        return (this.flags & 2) != 0;
    }

    public boolean isXPress() {
        return this.isCompressed() && (this.flags & 0x20000) != 0;
    }

    public boolean isLZX() {
        return this.isCompressed() && (this.flags & 0x40000) != 0;
    }

    public void setCompressMode(CompressMode mode) {
        switch (mode) {
            case NONE: {
                this.flags &= 0xFFFFFFFD;
                this.compressionSize = 0;
                break;
            }
            case XPRESS: {
                this.flags |= 2;
                this.flags |= 0x20000;
                this.flags &= 0xFFFBFFFF;
                this.compressionSize = 32768;
                break;
            }
            case LZX: {
                this.flags |= 2;
                this.flags |= 0x40000;
                this.flags &= 0xFFFDFFFF;
                this.compressionSize = 32768;
            }
        }
    }

    public CompressMode getCompressMode() {
        if (!this.isCompressed()) {
            return CompressMode.NONE;
        }
        if (this.isXPress()) {
            return CompressMode.XPRESS;
        }
        if (this.isLZX()) {
            return CompressMode.LZX;
        }
        return CompressMode.INVALID;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Header [size=").append(this.size).append(", partNumber=").append(this.partNumber).append(", totalParts=").append(this.totalParts).append(", imageCount=").append(this.imageCount).append(", offsetTable=").append(this.offsetTable).append(", xmlData=").append(this.xmlData).append(", bootMetadata=").append(this.bootMetadata).append(", bootIndex=").append(this.bootIndex).append("]");
        return builder.toString();
    }
}

