/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rewim.core.Chunk;

public class FileResource
implements Iterable<Chunk> {
    private int originalSize;
    private List<Chunk> chunkTable = new LinkedList<Chunk>();
    private int base;
    private ByteBuffer buffer;

    public FileResource(ByteBuffer buffer, int originalSize) {
        this.buffer = buffer;
        this.originalSize = originalSize;
        this.initChunkTable();
    }

    private void initChunkTable() {
        Chunk last = new Chunk(0);
        this.chunkTable.add(last);
        while (this.originalSize > 32768) {
            int pos;
            last.endpos = pos = this.buffer.getInt();
            last = new Chunk(pos);
            this.chunkTable.add(last);
            this.originalSize -= 32768;
        }
        last.origSize = this.originalSize;
        last.endpos = this.buffer.remaining();
        this.base = this.buffer.position();
    }

    public int getBase() {
        return this.base;
    }

    @Override
    public Iterator<Chunk> iterator() {
        return this.chunkTable.iterator();
    }
}

