/*
 * Decompiled with CFR 0.152.
 */
package rewim.core;

import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import rewim.BadFormatException;
import rewim.WimElement;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.util.FileTimeUtil;

public class DirEntry
implements WimElement {
    private long length;
    private int attribute;
    private int secId;
    private long childrenOffset;
    private Date creationTime;
    private Date lastAccessTime;
    private Date lastWriteTime;
    private byte[] hash;
    private int reparseTag;
    private int liHardlink;
    private short streamCount;
    private short shortNameLength;
    private short fileNameLength;
    private byte[] fileNameBytes;
    private byte[] shortFileNameBytes;
    private String fileName;
    private String shortName;
    private int hashcode;
    private Image image;
    private DirEntry parent;
    private List<DirEntry> children = new LinkedList<DirEntry>();
    private String fullPath;
    private int offset;
    private File file;
    private long totalBytes = -1L;
    private int imageIndex;
    private static final String FILE_NAME_ENCODING = "UnicodeLittleUnmarked";
    public static final int BASE_LENGTH = 104;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    public static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
    public static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192;

    @Override
    public void read(ByteBuffer buffer) throws BadFormatException {
        this.offset = buffer.position();
        this.length = buffer.getLong();
        if (this.length == 0L) {
            return;
        }
        this.attribute = buffer.getInt();
        this.secId = buffer.getInt();
        this.childrenOffset = buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        long temp = buffer.getLong();
        this.creationTime = new Date(FileTimeUtil.fileTimeToSystemTime(temp));
        temp = buffer.getLong();
        this.lastAccessTime = new Date(FileTimeUtil.fileTimeToSystemTime(temp));
        temp = buffer.getLong();
        this.lastWriteTime = new Date(FileTimeUtil.fileTimeToSystemTime(temp));
        this.hash = new byte[20];
        buffer.get(this.hash);
        this.hashcode = Arrays.hashCode(this.hash);
        this.reparseTag = buffer.getInt();
        buffer.getInt();
        this.liHardlink = buffer.getInt();
        this.streamCount = buffer.getShort();
        this.shortNameLength = buffer.getShort();
        this.fileNameLength = buffer.getShort();
        this.fileNameBytes = new byte[this.fileNameLength];
        buffer.get(this.fileNameBytes);
        try {
            this.fileName = new String(this.fileNameBytes, FILE_NAME_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new BadFormatException("decode file name failed", e);
        }
        buffer.getShort();
        if (this.shortNameLength > 0) {
            this.shortFileNameBytes = new byte[this.shortNameLength];
            buffer.get(this.shortFileNameBytes);
            try {
                this.shortName = new String(this.shortFileNameBytes, FILE_NAME_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new BadFormatException("decode short name failed", e);
            }
        }
    }

    @Override
    public void write(ByteBuffer buffer) {
        while (buffer.position() < this.offset) {
            buffer.put((byte)0);
        }
        buffer.putLong(this.length);
        buffer.putInt(this.attribute);
        buffer.putInt(this.secId);
        buffer.putLong(this.childrenOffset);
        buffer.putLong(0L);
        buffer.putLong(0L);
        buffer.putLong(FileTimeUtil.systemTimeToFileTime(this.creationTime.getTime()));
        buffer.putLong(FileTimeUtil.systemTimeToFileTime(this.lastAccessTime.getTime()));
        buffer.putLong(FileTimeUtil.systemTimeToFileTime(this.lastWriteTime.getTime()));
        buffer.put(this.hash);
        buffer.putInt(this.reparseTag);
        buffer.putInt(0);
        buffer.putInt(this.liHardlink);
        buffer.putShort(this.streamCount);
        buffer.putShort(this.shortNameLength);
        buffer.putShort(this.fileNameLength);
        if (this.fileNameLength > 0) {
            buffer.put(this.fileNameBytes);
        }
        buffer.putShort((short)0);
        if (this.shortNameLength > 0) {
            buffer.put(this.shortFileNameBytes);
        }
    }

    @Override
    public void init() {
        this.secId = -1;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public void setAttribute(int attribute) {
        this.attribute = attribute;
    }

    public int getSecId() {
        return this.secId;
    }

    public void setSecId(int secId) {
        this.secId = secId;
    }

    public long getChildrenOffset() {
        return this.childrenOffset;
    }

    public void setChildrenOffset(long childrenOffset) {
        this.childrenOffset = childrenOffset;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastWriteTime() {
        return this.lastWriteTime;
    }

    public void setLastWriteTime(Date lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public int getReparseTag() {
        return this.reparseTag;
    }

    public void setReparseTag(int reparseTag) {
        this.reparseTag = reparseTag;
    }

    public int getLiHardlink() {
        return this.liHardlink;
    }

    public void setLiHardlink(int liHardlink) {
        this.liHardlink = liHardlink;
    }

    public short getStreamCount() {
        return this.streamCount;
    }

    public void setStreamCount(short streamCount) {
        this.streamCount = streamCount;
    }

    public short getShortNameLength() {
        return this.shortNameLength;
    }

    public void setShortNameLength(short shortNameLength) {
        this.shortNameLength = shortNameLength;
    }

    public short getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(short fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) throws Exception {
        this.fileName = fileName;
        this.fileNameBytes = fileName.getBytes(FILE_NAME_ENCODING);
        this.fileNameLength = (short)this.fileNameBytes.length;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) throws Exception {
        this.shortName = shortName;
        this.shortFileNameBytes = shortName.getBytes(FILE_NAME_ENCODING);
        this.shortNameLength = (short)this.shortFileNameBytes.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setParent(DirEntry parent) {
        this.parent = parent;
    }

    public DirEntry getParent() {
        return this.parent;
    }

    public List<DirEntry> getChildren() {
        return this.children;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.parent == null ? this.fileName : this.parent.getFullPath() + File.separator + this.fileName;
        }
        return this.fullPath;
    }

    public void listDir(PrintStream out) {
        out.println(this.getFullPath());
        for (DirEntry child : this.children) {
            child.listDir(out);
        }
    }

    public boolean isDir() {
        return (this.attribute & 0x10) != 0;
    }

    public long getTotalBytes() {
        if (this.totalBytes != -1L) {
            return this.totalBytes;
        }
        if (!this.isDir()) {
            ResourceHeader header = this.getHeader();
            this.totalBytes = header != null ? header.getHeaderShort().getOrigSize() : 0L;
            return this.totalBytes;
        }
        this.totalBytes = 0L;
        for (DirEntry child : this.children) {
            this.totalBytes += child.getTotalBytes();
        }
        return this.totalBytes;
    }

    public void setImageIndex(int imageIndex) {
        this.imageIndex = imageIndex;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public int hashCode() {
        return this.hashcode != 211350913 ? this.hashcode : super.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DirEntry [length=").append(this.length).append(", offset=").append(this.offset).append(", childrenOffset=").append(this.childrenOffset).append(", fileName=").append(this.fileName).append("]");
        return builder.toString();
    }

    public ResourceHeader getHeader() {
        return this.image.getLookupTable().get(this.hashcode);
    }

    public long getFileSize() {
        if (this.file != null) {
            return this.file.length();
        }
        if (this.image != null) {
            return this.getHeader().getHeaderShort().getSize();
        }
        throw new IllegalStateException("a entry must has at least one associated file or a image");
    }
}

