/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.xpress;

import rewim.compress.BitReader;
import rewim.compress.huffman.Symbol;
import rewim.compress.huffman.SymbolReader;

public class XPressSymbolReader
implements SymbolReader {
    private BitReader bitBuffer;
    private static final int SYMBOL_SIZE = 512;

    public XPressSymbolReader(BitReader bitBuffer) {
        this.bitBuffer = bitBuffer;
    }

    @Override
    public Symbol[] readSymbol() {
        Symbol[] symbols = new Symbol[512];
        for (int i = 0; i < 128; ++i) {
            byte b1 = (byte)this.bitBuffer.getBits(4);
            byte b2 = (byte)this.bitBuffer.getBits(4);
            byte b3 = (byte)this.bitBuffer.getBits(4);
            byte b4 = (byte)this.bitBuffer.getBits(4);
            symbols[i * 4] = new Symbol(i * 4, b4);
            symbols[i * 4 + 1] = new Symbol(i * 4 + 1, b3);
            symbols[i * 4 + 2] = new Symbol(i * 4 + 2, b2);
            symbols[i * 4 + 3] = new Symbol(i * 4 + 3, b1);
        }
        return symbols;
    }
}

