/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.xpress;

import java.nio.ByteBuffer;
import rewim.compress.BitWriter;
import rewim.compress.LZ77Encoder;
import rewim.compress.huffman.CanonicalHuffmanTree;

public class XPressEncoder
extends LZ77Encoder {
    private int[] frequency = new int[512];
    private ByteBuffer symbolBuffer;

    public XPressEncoder() {
        super(new LZ77Encoder.Option().setMinMatch(3).setMaxMatch(32768));
    }

    @Override
    public void setInput(ByteBuffer src) {
        super.setInput(src);
        this.frequency = new int[512];
        this.symbolBuffer = ByteBuffer.allocateDirect(src.remaining() * 4);
    }

    @Override
    protected void recordLiteral(byte b) {
        int n = b & 0xFF;
        this.frequency[n] = this.frequency[n] + 1;
        this.symbolBuffer.putShort((short)(b & 0xFF));
    }

    @Override
    protected void recordMatch(int length, int distance) {
        int bitsCount = distance == 1 ? 0 : 32 - Integer.numberOfLeadingZeros(distance) - 1;
        int symbol = bitsCount << 4 | (length -= 3) & 0xF;
        if (length > 15) {
            symbol |= 0xF;
        }
        int n = symbol + 256;
        this.frequency[n] = this.frequency[n] + 1;
        this.symbolBuffer.putShort((short)(symbol + 256));
        this.symbolBuffer.putInt(length);
        this.symbolBuffer.putInt(distance);
    }

    @Override
    protected void outputSymbols(ByteBuffer out) {
        this.symbolBuffer.flip();
        this.frequency[256] = this.frequency[256] + 1;
        CanonicalHuffmanTree.CodeWord[] codeTable = new CanonicalHuffmanTree(this.frequency).getCodeWords();
        BitWriter bitBuffer = new BitWriter(out);
        for (int i = 0; i < codeTable.length; i += 4) {
            bitBuffer.putBits(4, codeTable[i + 3].getLength());
            bitBuffer.putBits(4, codeTable[i + 2].getLength());
            bitBuffer.putBits(4, codeTable[i + 1].getLength());
            bitBuffer.putBits(4, codeTable[i + 0].getLength());
        }
        while (this.symbolBuffer.hasRemaining()) {
            CanonicalHuffmanTree.CodeWord symbol;
            short s = this.symbolBuffer.getShort();
            if (s < 256) {
                symbol = codeTable[s];
                bitBuffer.putBits(symbol.getLength(), symbol.getCode());
                continue;
            }
            int length = this.symbolBuffer.getInt();
            int offset = this.symbolBuffer.getInt();
            symbol = codeTable[s & 0xFF | 0x100];
            bitBuffer.putBits(symbol.getLength(), symbol.getCode());
            if (length >= 15) {
                if (length < 270) {
                    bitBuffer.putByte((byte)(length - 15));
                } else {
                    bitBuffer.putByte((byte)-1);
                    bitBuffer.putShort((short)length);
                }
            }
            bitBuffer.putBits(s >>> 4 & 0xF, offset);
        }
        CanonicalHuffmanTree.CodeWord end = codeTable[256];
        bitBuffer.putBits(end.getLength(), end.getCode());
        bitBuffer.end();
    }
}

