/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.xpress;

import java.nio.ByteBuffer;
import rewim.compress.BitReader;
import rewim.compress.Decoder;
import rewim.compress.huffman.HuffmanTree;
import rewim.compress.xpress.XPressSymbolReader;

public class XPressDecoder
implements Decoder {
    private BitReader bitBuffer;

    @Override
    public void setInput(ByteBuffer src) {
        this.bitBuffer = new BitReader(src);
    }

    @Override
    public void decode(ByteBuffer dest) {
        XPressSymbolReader symbolReader = new XPressSymbolReader(this.bitBuffer);
        HuffmanTree decodeTree = new HuffmanTree(symbolReader);
        decodeTree.init();
        decodeTree.setBitBuffer(this.bitBuffer);
        while (dest.remaining() > 0) {
            int symbol = decodeTree.decodeSymbol();
            if (symbol < 256) {
                dest.put((byte)symbol);
                continue;
            }
            int length = (symbol -= 256) & 0xF;
            int offset = (1 << (symbol >>= 4)) + this.bitBuffer.getBits(symbol);
            if (length == 15) {
                byte b = this.bitBuffer.getByte();
                length = b == -1 ? (int)this.bitBuffer.getShort() : (b & 0xFF) + 15;
            }
            length += 3;
            int pos = dest.position() - offset;
            for (int n = 0; n < length; ++n) {
                dest.put(dest.get(pos + n));
            }
        }
    }
}

