/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.lzx;

import java.nio.ByteBuffer;
import rewim.compress.BitReader;
import rewim.compress.Decoder;
import rewim.compress.huffman.HuffmanTree;
import rewim.compress.lzx.BitsSymbolReader;
import rewim.compress.lzx.MainTreeSymbolReader;

public class LZXDecoder
implements Decoder {
    private static final int UNDEFINED_BLOCK = 0;
    private static final int VERBATIM_BLOCK = 1;
    private static final int ALIGNED_BLOCK = 2;
    private static final int UNCOMPRESSED_BLOCK = 3;
    private static final int TRANSLATION_SIZE = 12000000;
    private BitReader bitBuffer;
    private int blockType;
    private HuffmanTree mainTree;
    private HuffmanTree lengthTree;
    private HuffmanTree offsetTree;
    private ByteBuffer mainTreePre = ByteBuffer.allocate(496);
    private ByteBuffer lengthTreePre = ByteBuffer.allocate(249);
    private int r0;
    private int r1;
    private int r2;
    private long decoded;
    private long origSize;

    public LZXDecoder() {
        this.resetState();
    }

    @Override
    public void setInput(ByteBuffer src) {
        this.bitBuffer = new BitReader(src);
        this.resetState();
    }

    @Override
    public void decode(ByteBuffer out) {
        out.mark();
        this.origSize = out.remaining();
        do {
            this.decoded += (long)this.decodeBlock(out);
        } while (this.decoded < this.origSize);
        this.translate(out);
    }

    private void resetState() {
        this.mainTree = null;
        this.lengthTree = null;
        this.offsetTree = null;
        this.blockType = 0;
        this.mainTreePre = ByteBuffer.allocate(496);
        this.lengthTreePre = ByteBuffer.allocate(249);
        this.r2 = 1;
        this.r1 = 1;
        this.r0 = 1;
        this.decoded = 0L;
    }

    public int decodeBlock(ByteBuffer out) {
        this.blockType = this.bitBuffer.getBits(3);
        if (this.blockType == 0 || this.blockType > 3) {
            throw new IllegalStateException();
        }
        int uncompressed = this.bitBuffer.getBits(1) != 1 ? this.bitBuffer.getBits(16) : 32768;
        if (this.blockType == 3) {
            int padding = this.bitBuffer.getBitsNum() - 16;
            if (this.bitBuffer.getBits(padding) != 0) {
                // empty if block
            }
            ByteBuffer byteBuf = this.bitBuffer.getBuf();
            byteBuf.position(byteBuf.position() - 2);
            this.r0 = byteBuf.getInt() - 1;
            this.r1 = byteBuf.getInt() - 1;
            this.r2 = byteBuf.getInt() - 1;
            for (int i = 0; i < uncompressed; ++i) {
                out.put(byteBuf.get());
            }
            if ((uncompressed & 1) != 0 && byteBuf.remaining() > 0) {
                byteBuf.get();
            }
            this.bitBuffer.reload();
            return uncompressed;
        }
        this.buildTrees();
        long endpos = this.origSize - (long)uncompressed - this.decoded;
        while ((long)out.remaining() > endpos) {
            int distance;
            int symbol = this.mainTree.decodeSymbol();
            if (symbol < 256) {
                out.put((byte)symbol);
                continue;
            }
            int length = (symbol -= 256) & 7;
            int slot = symbol >> 3;
            if (length == 7) {
                length += this.lengthTree.decodeSymbol();
            }
            length += 2;
            switch (slot) {
                case 0: {
                    distance = this.r0;
                    break;
                }
                case 1: {
                    distance = this.r1;
                    this.r1 = this.r0;
                    this.r0 = distance;
                    break;
                }
                case 2: {
                    distance = this.r2;
                    this.r2 = this.r0;
                    this.r0 = distance;
                    break;
                }
                default: {
                    int footer;
                    int extra = (slot >> 1) - 1;
                    if (this.blockType == 1) {
                        footer = this.bitBuffer.getBits(extra);
                        distance = 2 + (slot & 1) << extra | footer & ~(65535 << extra);
                    } else if (extra > 3) {
                        footer = this.bitBuffer.getBits(extra - 3);
                        int aligned = this.offsetTree.decodeSymbol();
                        distance = (2 + (slot & 1) << extra - 3 | footer & ~(65535 << extra - 3)) << 3 | aligned & 7;
                    } else if (extra == 3) {
                        int aligned = this.offsetTree.decodeSymbol();
                        distance = 2 + (slot & 1) << 3 | aligned & 7;
                    } else {
                        footer = this.bitBuffer.getBits(extra);
                        distance = 2 + (slot & 1) << extra | footer & ~(65535 << extra);
                    }
                    this.r2 = this.r1;
                    this.r1 = this.r0;
                    this.r0 = distance -= 2;
                }
            }
            while (length-- > 0) {
                byte b = out.get(out.position() - distance);
                out.put(b);
            }
        }
        return uncompressed;
    }

    public void buildTrees() {
        if (this.blockType == 2) {
            BitsSymbolReader offsetSymbolReader = new BitsSymbolReader(this.bitBuffer, 8, 3);
            this.offsetTree = new HuffmanTree(offsetSymbolReader);
            this.offsetTree.init();
            this.offsetTree.setBitBuffer(this.bitBuffer);
        }
        ByteBuffer mainTreeLen = ByteBuffer.allocate(496);
        mainTreeLen.limit(256);
        this.readLength(this.mainTreePre, mainTreeLen);
        mainTreeLen.limit(496);
        this.readLength(this.mainTreePre, mainTreeLen);
        mainTreeLen.position(0);
        MainTreeSymbolReader symbolReader = new MainTreeSymbolReader(mainTreeLen);
        this.mainTree = new HuffmanTree(symbolReader);
        this.mainTree.init();
        this.mainTree.setBitBuffer(this.bitBuffer);
        this.mainTreePre = mainTreeLen;
        ByteBuffer lengthTreeLen = ByteBuffer.allocate(249);
        this.readLength(this.lengthTreePre, lengthTreeLen);
        lengthTreeLen.position(0);
        symbolReader = new MainTreeSymbolReader(lengthTreeLen);
        this.lengthTree = new HuffmanTree(symbolReader);
        this.lengthTree.init();
        this.lengthTree.setBitBuffer(this.bitBuffer);
        this.lengthTreePre = lengthTreeLen;
    }

    private void readLength(ByteBuffer pre, ByteBuffer curr) {
        BitsSymbolReader preTreeSymbolReader = new BitsSymbolReader(this.bitBuffer, 20, 4);
        HuffmanTree preTree = new HuffmanTree(preTreeSymbolReader);
        preTree.init();
        preTree.setBitBuffer(this.bitBuffer);
        block5: while (curr.hasRemaining()) {
            int b = preTree.decodeSymbol();
            switch (b) {
                case 17: {
                    int zeros = 4 + this.bitBuffer.getBits(4);
                    while (zeros-- > 0) {
                        curr.put((byte)0);
                    }
                    continue block5;
                }
                case 18: {
                    int zeros = 20 + this.bitBuffer.getBits(5);
                    while (zeros-- > 0) {
                        curr.put((byte)0);
                    }
                    continue block5;
                }
                case 19: {
                    int same = 4 + this.bitBuffer.getBits(1);
                    byte value = (byte)((17 + pre.get(curr.position()) - preTree.decodeSymbol()) % 17);
                    while (same-- > 0) {
                        curr.put(value);
                    }
                    continue block5;
                }
            }
            curr.put((byte)((17 + pre.get(curr.position()) - b) % 17));
        }
    }

    private void translate(ByteBuffer out) {
        out.limit(out.position());
        out.reset();
        int start = out.position();
        while (out.remaining() > 10) {
            if (out.get() != -24) continue;
            int curpos = out.position() - start - 1;
            int absoff = out.getInt();
            int reloff = absoff >= -curpos && absoff < 12000000 ? (absoff >= 0 ? absoff - curpos : absoff + 12000000) : absoff;
            out.position(out.position() - 4);
            out.putInt(reloff);
        }
    }
}

