/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.huffman;

import java.util.LinkedList;
import rewim.compress.BitReader;
import rewim.compress.huffman.Node;
import rewim.compress.huffman.Symbol;
import rewim.compress.huffman.SymbolReader;

public class HuffmanTree {
    protected SymbolReader symbolReader;
    protected Symbol[] symbols;
    protected BitReader bitBuffer;
    protected Node root;

    public HuffmanTree(SymbolReader symbolReader) {
        this.symbolReader = symbolReader;
    }

    public void setBitBuffer(BitReader bitBuffer) {
        this.bitBuffer = bitBuffer;
    }

    public void init() {
        this.symbols = this.symbolReader.readSymbol();
        this.sortSymbols();
        this.buildTree();
    }

    private void buildTree() {
        int i;
        LinkedList<Node> queue = new LinkedList<Node>();
        this.root = new Node();
        queue.add(this.root);
        for (i = 0; i < this.symbols.length && this.symbols[i].length == 0; ++i) {
        }
        int childIndex = 0;
        Node node = null;
        while (i < this.symbols.length) {
            if (childIndex == 0) {
                node = (Node)queue.poll();
            }
            Node child = new Node();
            child.level = node.level + 1;
            node.children[childIndex] = child;
            childIndex = 1 - childIndex;
            if (child.level < this.symbols[i].length) {
                queue.add(child);
                continue;
            }
            child.leaf = true;
            child.symbol = this.symbols[i].symbol;
            ++i;
        }
        if (queue.size() != 0 && queue.poll() != this.root) {
            throw new AssertionError();
        }
    }

    public int decodeSymbol() {
        Node node = this.root;
        StringBuilder sb = new StringBuilder();
        do {
            int bit = this.bitBuffer.getBits(1);
            sb.append(bit);
            node = node.children[bit];
        } while (!node.leaf);
        return node.symbol;
    }

    private void sortSymbols() {
        for (int i = 1; i < this.symbols.length; ++i) {
            Symbol temp = this.symbols[i];
            for (int j = i; j > 0 && temp.compareTo(this.symbols[j - 1]) < 0; --j) {
                this.symbols[j] = this.symbols[j - 1];
            }
            this.symbols[j] = temp;
        }
    }

    protected void dumpSymbols() {
        for (Symbol s : this.symbols) {
            System.out.print(s.length + ", ");
        }
        System.out.println();
    }

    public void dumpTree() {
        this.dumpNode(this.root, 0);
    }

    protected void dumpNode(Node node, int path) {
        if (node.leaf) {
            System.out.print(node.symbol);
            System.out.print("|");
            String code = Integer.toBinaryString(path);
            for (int i = 0; i < node.level - code.length(); ++i) {
                System.out.print(0);
            }
            System.out.println(code);
        } else {
            this.dumpNode(node.children[0], path << 1);
            this.dumpNode(node.children[1], (path << 1) + 1);
        }
    }
}

