/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress.huffman;

import java.util.Arrays;
import java.util.PriorityQueue;
import rewim.compress.huffman.TreeTooDeepException;

public class CanonicalHuffmanTree {
    private int[] frequency;
    private CodeWord[] codeWords;

    public CanonicalHuffmanTree(int[] frequency) {
        this.frequency = frequency;
        this.codeWords = new CodeWord[frequency.length];
        for (int i = 0; i < frequency.length; ++i) {
            this.codeWords[i] = new CodeWord(i);
        }
        block3: while (true) {
            try {
                this.buildTree();
            }
            catch (TreeTooDeepException e) {
                int i = 0;
                while (true) {
                    if (i >= frequency.length) continue block3;
                    if (frequency[i] > 1) {
                        int n = i;
                        frequency[n] = frequency[n] >> 1;
                    }
                    ++i;
                }
            }
            break;
        }
    }

    private void buildTree() {
        PriorityQueue<Node> q = new PriorityQueue<Node>();
        for (int i = 0; i < this.frequency.length; ++i) {
            if (this.frequency[i] <= 0) continue;
            q.add(new Node(i, this.frequency[i]));
        }
        while (q.size() > 1) {
            Node n1 = (Node)q.poll();
            Node n2 = (Node)q.poll();
            q.add(new Node(n1, n2));
        }
        Node root = (Node)q.poll();
        this.setLength(root, 0);
        Object[] dummy = (CodeWord[])this.codeWords.clone();
        Arrays.sort(dummy);
        int code = 0;
        int length = 1;
        for (Object word : dummy) {
            if (((CodeWord)word).length == 0) continue;
            if (length < ((CodeWord)word).length) {
                code <<= ((CodeWord)word).length - length;
                length = ((CodeWord)word).length;
            }
            this.codeWords[((CodeWord)word).index].code = code++;
        }
    }

    public CodeWord[] getCodeWords() {
        return this.codeWords;
    }

    private void setLength(Node node, int length) {
        if (node == null) {
            return;
        }
        if (length >= 16) {
            throw new TreeTooDeepException();
        }
        if (node.symbol != -1) {
            this.codeWords[node.symbol].length = length;
        }
        this.setLength(node.c1, length + 1);
        this.setLength(node.c2, length + 1);
    }

    public static class CodeWord
    implements Comparable<CodeWord> {
        private int index;
        private int length;
        private int code;

        public CodeWord(int index) {
            this.index = index;
        }

        public int getLength() {
            return this.length;
        }

        public int getCode() {
            return this.code;
        }

        @Override
        public int compareTo(CodeWord o) {
            if (this.length - o.length == 0) {
                return this.index - o.index;
            }
            return this.length - o.length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.length);
            String s = Integer.toBinaryString(this.code);
            for (int i = 0; i < this.length - s.length(); ++i) {
                sb.append('0');
            }
            sb.append(s);
            return sb.toString();
        }
    }

    private class Node
    implements Comparable<Node> {
        int symbol;
        int freq;
        Node c1;
        Node c2;
        int height;

        public Node(int symbol, int freq) {
            this.symbol = symbol;
            this.freq = freq;
        }

        public Node(Node c1, Node c2) {
            this.symbol = -1;
            this.freq = c1.freq + c2.freq;
            this.c1 = c1;
            this.c2 = c2;
            this.height = Math.max(c1.height, c2.height) + 1;
        }

        @Override
        public int compareTo(Node o) {
            return this.freq - o.freq;
        }
    }
}

