/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import rewim.compress.Encoder;

public abstract class LZ77Encoder
implements Encoder {
    private ByteBuffer src;
    protected Option option;
    private byte[] lookupArray;
    private Map<Integer, Deque<Integer>> matchTable;
    private int matchPos;

    public LZ77Encoder() {
        this(new Option());
    }

    public LZ77Encoder(Option option) {
        this.option = option;
        this.lookupArray = new byte[option.minMatch];
    }

    private int currentHash() {
        int pos = this.src.position();
        this.src.get(this.lookupArray);
        this.src.position(pos);
        return Arrays.hashCode(this.lookupArray);
    }

    private void insertHash(int hash) {
        Deque<Integer> q = this.matchTable.get(hash);
        if (q == null) {
            q = new LinkedList<Integer>();
            this.matchTable.put(hash, q);
        }
        q.addFirst(this.src.position());
    }

    private int longestMatch(int hash, int max) {
        int pos;
        Deque<Integer> q = this.matchTable.get(hash);
        if (q == null) {
            return 0;
        }
        int curr = this.src.position();
        int best = 0;
        Iterator<Integer> i$ = q.iterator();
        while (i$.hasNext() && curr - (pos = i$.next().intValue()) <= this.option.maxLookBack) {
            int len = 0;
            while (this.src.get(pos + len) == this.src.get(curr + len)) {
                if (++len < max) continue;
                this.matchPos = pos;
                return max;
            }
            if (len <= best) continue;
            best = len;
            this.matchPos = pos;
        }
        return best;
    }

    @Override
    public void setInput(ByteBuffer src) {
        this.src = src;
        this.matchPos = 0;
        this.matchTable = new HashMap<Integer, Deque<Integer>>();
    }

    @Override
    public void encode(ByteBuffer out) {
        ByteBuffer srcDup = this.src.duplicate();
        while (this.src.hasRemaining()) {
            if (this.src.remaining() < this.option.minMatch) {
                this.recordLiteral(this.src.get());
                continue;
            }
            int hash = this.currentHash();
            int matchLen = this.longestMatch(hash, Math.min(this.option.maxMatch, this.src.remaining()));
            if (matchLen < this.option.minMatch || this.matchPos == 0) {
                this.insertHash(hash);
                this.recordLiteral(this.src.get());
                continue;
            }
            this.recordMatch(matchLen, this.src.position() - this.matchPos);
            for (int i = 0; i < matchLen; ++i) {
                if (this.src.remaining() >= this.option.minMatch) {
                    this.insertHash(this.currentHash());
                }
                this.src.get();
            }
        }
        int initPos = out.position();
        this.outputSymbols(out);
        int compressedSize = out.position() - initPos;
        if (compressedSize > srcDup.remaining()) {
            out.position(initPos);
            while (srcDup.hasRemaining()) {
                out.put(srcDup.get());
            }
        }
    }

    protected abstract void recordLiteral(byte var1);

    protected abstract void recordMatch(int var1, int var2);

    protected abstract void outputSymbols(ByteBuffer var1);

    public static class Option {
        private int minMatch = 2;
        private int maxMatch = 256;
        private int maxLookBack = 32768;

        public Option setMinMatch(int minMatch) {
            this.minMatch = minMatch;
            return this;
        }

        public int getMinMatch() {
            return this.minMatch;
        }

        public Option setMaxMatch(int maxMatch) {
            this.maxMatch = maxMatch;
            return this;
        }

        public int getMaxMatch() {
            return this.maxMatch;
        }

        public Option setMaxLookBack(int maxLookBack) {
            this.maxLookBack = maxLookBack;
            return this;
        }

        public int getMaxLookBack() {
            return this.maxLookBack;
        }
    }
}

