/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BitWriter {
    private ByteBuffer bitsOut;
    private ByteBuffer byteOut;
    private int buffer;
    private int freeBits;
    private int bitsNext;
    private static final int[] mask = new int[16];

    public BitWriter(ByteBuffer out) {
        this.bitsOut = out;
        this.freeBits = 16;
        this.byteOut = out.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.bitsNext = this.byteOut.position() + 2;
        this.byteOut.position(this.byteOut.position() + 4);
    }

    public void putBits(int len, int value) {
        if (len <= this.freeBits) {
            this.buffer <<= len;
            this.buffer |= value & mask[len];
            this.freeBits -= len;
        } else {
            this.buffer <<= this.freeBits;
            this.buffer |= value >> len - this.freeBits & mask[this.freeBits];
            this.flush();
            this.freeBits += 16 - len;
            this.buffer = value;
        }
    }

    public void flush() {
        this.bitsOut.putShort((short)this.buffer);
        this.bitsOut.position(this.bitsNext);
        this.bitsNext = this.byteOut.position();
        this.byteOut.position(this.bitsNext + 2);
    }

    public void end() {
        if (this.freeBits != 16) {
            this.buffer <<= this.freeBits;
            this.bitsOut.putShort((short)this.buffer);
        }
        this.bitsOut.position(Math.max(this.bitsNext, this.byteOut.position()));
    }

    public void putByte(byte b) {
        this.byteOut.put(b);
    }

    public void putShort(short s) {
        this.byteOut.putShort(s);
    }

    static {
        for (int i = 1; i < mask.length; ++i) {
            BitWriter.mask[i] = mask[i - 1] * 2 + 1;
        }
    }
}

