/*
 * Decompiled with CFR 0.152.
 */
package rewim.compress;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BitReader {
    private ByteBuffer buf;
    private int mask;
    private int bits;
    private long initPos;
    private int exceed;
    private boolean byteExceed;

    public BitReader(ByteBuffer buf) {
        this.buf = buf;
        this.initPos = buf.position();
    }

    public int seekBits(int n) {
        if (n == 0) {
            return 0;
        }
        return this.mask >>> 32 - n;
    }

    public int getBits(int n) {
        if (this.bits < 16) {
            if (this.buf.remaining() >= 2) {
                this.mask |= this.buf.getShort() << 16 - this.bits & (this.bits == 0 ? -1 : ~(-1 << 32 - this.bits));
            } else if (++this.exceed > 2) {
                throw new BufferUnderflowException();
            }
            this.bits += 16;
        }
        int res = this.seekBits(n);
        this.shift(n);
        return res;
    }

    public void shift(int n) {
        this.mask <<= n;
        this.bits -= n;
    }

    public byte getByte() {
        return this.buf.get();
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public long getOffset() {
        return ((long)this.buf.position() - this.initPos) * 8L - (long)this.bits;
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public int getBitsNum() {
        return this.bits;
    }

    public void reload() {
        this.bits = 16;
        if (this.buf.remaining() > 2) {
            this.mask = this.buf.getShort() << 16;
        }
    }
}

