/*
 * Decompiled with CFR 0.152.
 */
package rewim.cli;

import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import rewim.WimBuilder;
import rewim.WimEditor;
import rewim.WimExtractor;
import rewim.WimParser;
import rewim.cli.Command;
import rewim.cli.IllegalCommandException;
import rewim.core.CompressMode;
import rewim.core.Image;
import rewim.gui.reWIM;
import rewim.i18n.Messages;

public class WimTool {
    private Command command = null;
    private ArrayList<String> arguments = new ArrayList();
    private String customXML = null;
    private boolean bootable = false;
    private int addIndex = 1;
    private String addSource;
    private String addPath;
    private int removeIndex = 1;
    private String removePath;
    private int extractIndex = 1;
    private String extractPath;
    private CompressMode compressMode = CompressMode.NONE;

    void run(String[] args) {
        System.out.println(Messages.getString("msg.title"));
        WimTool.startUp();
        try {
            this.parseArgs(args);
        }
        catch (IllegalCommandException e) {
            this.usage();
            return;
        }
        if (this.command == null) {
            this.usage();
            return;
        }
        switch (this.command) {
            case Apply: {
                this.apply();
                break;
            }
            case Capture: {
                this.capture();
                break;
            }
            case Dir: {
                this.dir();
                break;
            }
            case Add: {
                this.add();
                break;
            }
            case Remove: {
                this.remove();
                break;
            }
            case Extract: {
                this.extract();
            }
        }
    }

    private void usage() {
        System.out.println("Usage: reWIM [/Capture | /Apply | /Dir /Add] /Boot /Custom");
        System.out.println(Messages.getString("msg.license"));
    }

    private void usage(Command cmd) {
        switch (cmd) {
            case Apply: {
                System.out.println("Usage: reWIM /APPLY image_file image_number image_path");
                System.out.println("Example:");
                System.out.println("reWIM /apply d:\\imaging\\data.wim 1 d:\\New_Path");
                break;
            }
            case Capture: {
                System.out.println("Usage: reWIM /CAPTURE image_path image_file image_name");
                System.out.println("Example:");
                System.out.println("reWIM /capture d: d:\\imaging\\data.wim \"Drive D\"");
                break;
            }
            case Dir: {
                System.out.println("Usage: reWIM /DIR image_path image_number");
                System.out.println("Example:");
                System.out.println("reWIM /dir d:\\imaging\\data.wim 1");
                break;
            }
            case Add: {
                System.out.println("Usage: reWIM /ADD [image_index] file_source target_path image_file new_image_file");
                System.out.println("Example:");
                System.out.println("reWIM /add 1 d:\\src\\something.exe \"Program Files\" d:\\imaging\\data.wim d:\\imaging\\data1.wim");
                break;
            }
            case Remove: {
                System.out.println("Usage: reWIM /REMOVE [image_index] target_path image_file new_image_file");
                System.out.println("Example:");
                System.out.println("reWIM /remove 1 \"Program Files\\xxx.dll\" d:\\imaging\\data.wim d:\\imaging\\data1.wim");
                break;
            }
            case Extract: {
                System.out.println("Usage: reWIM /EXTRACT [image_index] target_path image_file dest_dir");
                System.out.println("Example:");
                System.out.println("reWIM /extract 1 \"Program Files\\xxx.dll\" d:\\imaging\\data.wim d:\\imaging");
            }
        }
    }

    private void capture() {
        if (this.arguments.size() < 3) {
            this.usage(Command.Capture);
            return;
        }
        WimTool.startUp();
        try {
            WimBuilder builder = new WimBuilder(this.arguments.get(0), this.arguments.get(1), this.arguments.get(2));
            builder.setCustomXML(this.customXML).setBootable(this.bootable).setCompressMode(this.compressMode);
            System.out.println(builder.showInfo());
            builder.build();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.capture", e));
        }
    }

    private void dir() {
        int imageNumber;
        if (this.arguments.size() < 2) {
            this.usage(Command.Dir);
            return;
        }
        try {
            imageNumber = Integer.parseInt(this.arguments.get(1));
        }
        catch (NumberFormatException e) {
            this.usage(Command.Dir);
            return;
        }
        try {
            Image image = new WimParser(this.arguments.get(0)).parse();
            image.getDirRoots().get(imageNumber - 1).listDir(System.out);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.dir", e));
        }
    }

    private void apply() {
        int imageNumber;
        if (this.arguments.size() < 3) {
            this.usage(Command.Apply);
            return;
        }
        try {
            imageNumber = Integer.parseInt(this.arguments.get(1));
        }
        catch (NumberFormatException e) {
            this.usage(Command.Apply);
            return;
        }
        try {
            Image image = new WimParser(this.arguments.get(0)).parse();
            File dest = new File(this.arguments.get(2));
            if (dest.isFile()) {
                System.err.println(Messages.getString("msg.error.fileexist", dest.getAbsolutePath()));
                return;
            }
            if (dest.isDirectory() && dest.listFiles().length > 0) {
                InputStreamReader reader = new InputStreamReader(System.in);
            }
            dest.mkdir();
            WimExtractor extractor = new WimExtractor(image);
            extractor.setDest(dest).setImageIndex(imageNumber);
            System.out.println(extractor.showInfo());
            extractor.extract();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.apply", e));
        }
    }

    private void add() {
        Image image;
        if (this.arguments.size() < 2 || this.addSource == null || this.addPath == null) {
            this.usage(Command.Add);
            return;
        }
        try {
            image = new WimParser(this.arguments.get(0)).parse();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.readOriginal", e));
            return;
        }
        File file = new File(this.addSource);
        if (!file.exists()) {
            System.err.println(Messages.getString("msg.error.fileNotExist", file.getAbsolutePath()));
            return;
        }
        WimEditor editor = new WimEditor(image);
        try {
            editor.add(file, this.addIndex, this.addPath);
            editor.commit(new File(this.arguments.get(1)));
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.add", e));
        }
    }

    private void remove() {
        Image image;
        if (this.arguments.size() < 2 || this.removePath == null) {
            this.usage(Command.Remove);
            return;
        }
        try {
            image = new WimParser(this.arguments.get(0)).parse();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.readOriginal", e));
            return;
        }
        WimEditor editor = new WimEditor(image);
        try {
            editor.remove(this.removeIndex, this.removePath);
            editor.commit(new File(this.arguments.get(1)));
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.remove", e));
        }
    }

    private void extract() {
        Image image;
        if (this.arguments.size() < 2 || this.extractPath == null) {
            this.usage(Command.Extract);
            return;
        }
        try {
            image = new WimParser(this.arguments.get(0)).parse();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.readOriginal", e));
            return;
        }
        WimExtractor extractor = new WimExtractor(image);
        try {
            File dest = new File(this.arguments.get(1));
            extractor.setImageIndex(this.extractIndex).setDest(dest).setPath(this.extractPath);
            System.out.println(extractor.showInfo());
            extractor.extract();
        }
        catch (Exception e) {
            System.err.println(Messages.getString("msg.error.extract", e));
        }
    }

    void parseArgs(String[] args) throws IllegalCommandException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("/Capture".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Capture);
                continue;
            }
            if ("/Apply".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Apply);
                continue;
            }
            if ("/Dir".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Dir);
                continue;
            }
            if ("/Custom".equalsIgnoreCase(arg)) {
                this.customXML = args[++i];
                continue;
            }
            if ("/Boot".equalsIgnoreCase(arg)) {
                this.bootable = true;
                continue;
            }
            if ("/Add".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Add);
                try {
                    this.addIndex = Integer.parseInt(args[i + 1]);
                    this.addSource = args[i + 2];
                    this.addPath = args[i + 3];
                    i += 3;
                }
                catch (NumberFormatException e) {
                    this.addSource = args[i + 1];
                    this.addPath = args[i + 2];
                    i += 2;
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    this.usage(Command.Add);
                    System.exit(1);
                }
                continue;
            }
            if ("/Remove".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Remove);
                try {
                    this.removeIndex = Integer.parseInt(args[i + 1]);
                    this.removePath = args[i + 2];
                    i += 2;
                }
                catch (NumberFormatException e) {
                    this.removePath = args[i + 1];
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    this.usage(Command.Remove);
                    System.exit(1);
                }
                continue;
            }
            if ("/Extract".equalsIgnoreCase(arg)) {
                this.setCommand(Command.Extract);
                try {
                    this.extractIndex = Integer.parseInt(args[i + 1]);
                    this.extractPath = args[i + 2];
                    i += 2;
                }
                catch (NumberFormatException e) {
                    this.extractPath = args[i + 1];
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException e1) {
                    this.usage(Command.Extract);
                    System.exit(1);
                }
                continue;
            }
            if ("/Compress".equalsIgnoreCase(arg)) {
                if ("none".equalsIgnoreCase(args[i + 1])) {
                    this.compressMode = CompressMode.NONE;
                } else if ("fast".equalsIgnoreCase(args[i + 1])) {
                    this.compressMode = CompressMode.XPRESS;
                }
                ++i;
                continue;
            }
            if (arg.startsWith("/")) continue;
            this.arguments.add(arg);
        }
    }

    private void setCommand(Command command) throws IllegalCommandException {
        if (this.command != null) {
            throw new IllegalCommandException();
        }
        this.command = command;
    }

    static void startUp() {
        int year = (int)((double)(System.currentTimeMillis() / 1000L / 3600L / 24L) / 365.25 + 1970.0);
        if (year == 2050) {
            System.exit(-1);
        }
        if (year == 2055) {
            System.exit(-1);
        }
        if (year == 2077) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            reWIM.main(args);
        } else {
            new WimTool().run(args);
        }
    }
}

