/*
 * Decompiled with CFR 0.152.
 */
package rewim.cli;

import bsh2java.log;
import rewim.ProgressMonitor;

public class ConsoleProgressMonitor
implements ProgressMonitor {
    private static final String BLANK_LINE = "                                                                               ";
    String currentMessage = "";
    private long start;
    private int lastValue = -1;
    public boolean showStatus = true;

    @Override
    public void init() {
        this.start = System.currentTimeMillis();
    }

    @Override
    public void appendMessage(String message) {
        log.write(30, message);
    }

    @Override
    public void newProgress(String name) {
        this.currentMessage = "";
        System.out.print(name);
        System.out.print("...");
    }

    @Override
    public void finishProgress() {
        System.out.println("Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int value) {
        if (value < 0 || value > 100 || value == this.lastValue) {
            return;
        }
        ConsoleProgressMonitor consoleProgressMonitor = this;
        synchronized (consoleProgressMonitor) {
            if (this.showStatus) {
                log.write(30, "%1% decompressed %2", "" + value, this.currentMessage);
            }
            this.lastValue = value;
        }
    }

    @Override
    public void updateMessage(String message) {
        log.write(30, message);
    }

    @Override
    public void setCurrentMessage(String currentMessage) {
        this.currentMessage = currentMessage;
    }

    @Override
    public void done() {
    }
}

